var Detector = function() {
 var baseFonts = ['monospace', 'sans-serif', 'serif'];
 var testString = "mmmmmmmmmmlli";
 var testSize = '72px';
 var h = document.getElementsByTagName("body")[0];
 var s = document.createElement("span");
 s.style.fontSize = testSize;
 s.innerHTML = testString;
 var defaultWidth = {};
 var defaultHeight = {};
 for (var index in baseFonts) {
  s.style.fontFamily = baseFonts[index];
  h.appendChild(s);
  defaultWidth[baseFonts[index]] = s.offsetWidth;
  defaultHeight[baseFonts[index]] = s.offsetHeight;
  h.removeChild(s);
 }

 function detect(font) {
  var detected = false;
  for (var index in baseFonts) {
   s.style.fontFamily = font + ',' + baseFonts[index];
   h.appendChild(s);
   var matched = (s.offsetWidth != defaultWidth[baseFonts[index]] || s.offsetHeight != defaultHeight[baseFonts[index]]);
   h.removeChild(s);
   detected = detected || matched;
  }
  return detected;
 }
 this.detect = detect;
};

function diftongYRa(s,t,v,V){
 switch(s.charCodeAt(t+1)){
  case 73:return "&#1101;";  //
  case 85:return v+"&#1091;"; //+
  case 105:return "&#1101;";  //
  case 117:return v+"&#1091;";
  case 1067:return "&#1069;"; //
  case 1068:return "&#1069;";
  case 1069:return "&#1069;";
  case 1070:return "&#1101;";
  case 1071:return "&#1075;"+"&#1101;";
  case 1072:return "&#1069;";
  case 1073:return "&#1075;&#1069;";
  case 1074:return "&#1069;";
  case 1075:return "&#1075;&#1069;";
  case 1076:return "&#1069;";
  case 1077:return "&#1075;&#1069;";
  case 1078:return V+"&#1091;";
  case 1079:return V+"&#1091;";
  case 1080:return V+"&#1091;";
  case 1081:return v+"&#1091;";
  case 1082:return "&#1075;"+v+"&#1091;";
  case 1083:return V+"&#1091;";
  case 1084:return "&#1075;"+V+"&#1091;";
  case 1085:return V+"&#1091;";
  case 1086:return "&#1075;"+V+"&#1091;";
  case 1087:return V+"&#1091;";
  case 1088:return "&#1075;"+V+"&#1091;";
  default: return "";
 }
}

function diftongYRe(s,t,v,V){
 switch(s.charCodeAt(t+1)){
  case 73:return "&#1080;";  //
  case 85:return v+"&#1091;"; //+
  case 105:return "&#1080;";  //
  case 117:return v+"&#1091;";
  case 1067:return "&#1048;"; //
  case 1068:return "&#1048;";
  case 1069:return "&#1048;";
  case 1070:return "&#1080;";
  case 1071:return "&#1075;"+"&#1080;";
  case 1072:return "&#1048;";
  case 1073:return "&#1075;&#1048;";
  case 1074:return "&#1048;";
  case 1075:return "&#1075;&#1048;";
  case 1076:return "&#1048;";
  case 1077:return "&#1075;&#1048;";
  case 1078:return V+"&#1091;";
  case 1079:return V+"&#1091;";
  case 1080:return V+"&#1091;";
  case 1081:return v+"&#1091;";
  case 1082:return "&#1075;"+v+"&#1091;";
  case 1083:return V+"&#1091;";
  case 1084:return "&#1075;"+V+"&#1091;";
  case 1085:return V+"&#1091;";
  case 1086:return "&#1075;"+V+"&#1091;";
  case 1087:return V+"&#1091;";
  case 1088:return "&#1075;"+V+"&#1091;";
  default: return "";
 }
}

function diftongYRh(s,t,v,V){
 switch(s.charCodeAt(t+1)){
  case 85:return v+"&#1091;"; //+
  case 117:return v+"&#1091;";
  case 1078:return V+"&#1091;";
  case 1079:return V+"&#1091;";
  case 1080:return V+"&#1091;";
  case 1081:return v+"&#1091;";
  case 1082:return "&#1075;"+v+"&#1091;";
  case 1083:return V+"&#1091;";
  case 1084:return "&#1075;"+V+"&#1091;";
  case 1085:return V+"&#1091;";
  case 1086:return "&#1075;"+V+"&#1091;";
  case 1087:return V+"&#1091;";
  case 1088:return "&#1075;"+V+"&#1091;";
  default: return "";
 }
}

function diftongYRou(s,t,v,V){
 switch(s.charCodeAt(t+1)){
  case 73:return "&#1080;";  //
  case 105:return "&#1080;"; // 
  case 1067:return "&#1048;"; //
  case 1068:return "&#1048;";
  case 1069:return "&#1048;";
  case 1070:return "&#1080;";
  case 1071:return "&#1075;"+"&#1080;";
  case 1072:return "&#1048;";
  case 1073:return "&#1075;&#1048;";
  case 1074:return "&#1048;";
  case 1075:return "&#1075;&#1048;";
  case 1076:return "&#1048;";
  case 1077:return "&#1075;&#1048;";
  default: return "";
 }
}


function digraphYR(s,t,v,V){
 if (s.length<t+1) return "";
 switch(s.charAt(t+1)){
  case "u":case "U":return "&#1091;";
  default: switch(s.charCodeAt(t+1)){
   case 1078:return "&#1059;";
   case 1079:return "&#1059;";
   case 1080:return "&#1059;";
   case 1081:return "&#1091;";
   case 1082:return "&#1075;"+"&#1091;";
   case 1083:return "&#1059;";
   case 1084:return "&#1075;&#1059;";
   case 1085:return "&#1059;";
   case 1086:return "&#1075;&#1059;";
   case 1087:return "&#1059;";
   case 1088:return "&#1075;&#1059;";
   default: return diftongYRou(s,t,v,V);
  }
 }
}


function translitYR(s){
r='';
for (t=0;t<s.length;t++) {
 switch(s.charAt(t)) {
	case "A": case "a":d=diftongYRa(s,t,"&#1072;","&#1040;");if(d!="") {r+=d;t++;} else r+="&#1072;";break;
	case "B": case "b":r+="&#1074;";break;
	case "G": case "g":if (t){switch(s.charAt(t+1)) {case "G":case "g":case "K":case "k":case "X":case "x":case "J":case "j":r+="&#1085;";break; default: r+="&#1075;";}} else r+="&#1075;";break;
	case "D": case "d":r+="&#1076;";break;
	case "E": case "e":d=diftongYRe(s,t,"&#1101;","&#1069;");if(d!="") {r+=d;t++;} else r+="&#1101;";break;
	case "Z": case "z":r+="&#1076;&#1079;";break;
	case "H": case "h":d=diftongYRh(s,t,"&#1080;","&#1048;");if(d!="") {r+=d;t++;} else r+="&#1080;";break;
	case "Y": case "y":r+="&#1092;";break;
	case "I": case "i":r+="&#1080;";break;
	case "K": case "k":r+="&#1082;";break;
	case "L": case "l":r+="&#1083;";break;
	case "M": case "m":r+="&#1084;";break;
	case "N": case "n":r+="&#1085;";break;
	case "J": case "j":r+="&#1082;&#1089;";break;
	case "O": case "o":d=digraphYR(s,t,"&#1086;","&#1054;");if (d!="") {r+=d; t++;} else r+="&#1086;";break;
	case "P": case "p":r+="&#1087;";break;
	case "R": case "r":r+="&#1088;";break;
	case "S": case "s": case "w":r+="&#1089;";break;
	case "T": case "t":r+="&#1090;";break;
	case "U": case "u":d=diftongYRou(s,t,"&#1080;","&#1048;");if(d!=""){r+=d;t++;} else r+="&#1080;";break;
	case "F": case "f":r+="&#1092;";break;
	case "X": case "x":r+="&#1093;";break;
	case "C": case "c":r+="&#1087;&#1089;";break;
	case "V": case "v":r+="&#1086;";break;
	default: switch(s.charCodeAt(t)) {
		case 35:r+="&#1080;";break;
		case 38:r+="&#1072;";break;
		case 44:r+=" ";break;
		case 61:r+="&#1088;";break;
		case 64:r+="&#1048;";break;
		case 123:r+=" ";break;
		case 125:r+=" ";break;
		case 152:r+="&#1040;";break;
		case 161:r+="&#1075;&#1048;";break;
		case 162:r+="&#1069;";break;
		case 163:r+="&#1048;";break;
		case 164:r+="&#1101;";break;
		case 165:r+="&#1075;&#1048;";break;
		case 166:r+="&#1069;";break;
		case 167:r+="&#1075;&#1069;";break;
		case 169:r+="&#1075;&#1069;";break;
		case 170:r+="&#1048;";break;
		case 172:r+="&#1048;";break;
		case 174:r+="&#1048;";break;
		case 175:r+="&#1054;";break;
		case 176:r+="&#1048;";break;
		case 177:r+="&#1080;";break;
		case 181:r+="&#1048;";break;
		case 182:r+="&#1075;&#1048;";break;
		case 183:r+="&#1048;";break;
		case 186:r+="&#1080;";break;
		case 187:r+="&#1048;";break;
		case 191:r+="&#1048;";break;
		case 192:r+="&#1075;&#1054;";break;
		case 193:r+="&#1048;";break;
		case 194:r+="&#1075;&#1048;";break;
		case 195:r+="&#1054;";break;
		case 198:r+="&#1048;";break;
		case 200:r+="&#1080;";break;
		case 201:r+="";break;
		case 202:r+="&#1048;";break;
		case 203:r+="&#1048;";break;
		case 204:r+="&#1048;";break;
		case 205:r+="&#1075;&#1080;";break;
		case 206:r+="&#1048;";break;
		case 207:r+="&#1075;&#1048;";break;
		case 209:r+="&#1075;";break;
		case 210:r+="&#1054;";break;
		case 211:r+="&#1075;&#1048;";break;
		case 212:r+="&#1048;";break;
		case 213:r+="&#1075;&#1054;";break;
		case 216:r+="&#1048;";break;
		case 217:r+="&#1086;";break;
		case 218:r+="&#1054;";break;
		case 219:r+="&#1080;";break;
		case 223:r+="&#1075;&#1069;";break;
		case 227:r+="&#1040;";break;
		//case 228: see next
		case 229:r+="&#1040;";break;
		case 230:r+="&#1048;";break;
		case 231:r+="&#1040;";break;
		case 232:r+="&#1075;&#1072;";break;
		case 233:r+="&#1072;";break;
		case 234:r+="&#1040;";break;
		case 235:r+="&#1075;&#1040;";break;
		case 236:r+="&#1075;&#1040;";break;
		case 237:r+="&#1040;";break;
		case 238:r+="&#1040;";break;
		case 239:r+="&#1075;&#1040;";break;
		case 241:r+="&#1040;";break;
		case 243:r+="&#1040;";break;
		case 244:r+="&#1072;";break;
		case 245:r+="&#1040;";break;
		case 246:r+="&#1075;&#1072;";break;
		case 247:r+="&#1075;&#1054;";break;
		case 248:r+="&#1075;&#1048;";break;
		case 249:r+="&#1040;";break;
		case 250:r+="&#1075;&#1040;";break;
		case 251:r+="&#1075;&#1040;";break;
		case 252:r+="&#1040;";break;
		case 255:r+="&#1075;&#1054;";break;
		case 1025:r+="&#1069;";break;
		case 1028:r+="&#1075;&#1040;";break;
		case 1029:case 1030:r+="&#1075;&#1080;";break;
		case 1031:r+="&#1048;";break;
		case 1032:r+="&#1048;";break;
		//case 1032: see next
		case 1034:r+="&#1040;";break;
		case 1035:r+="&#1072;";break;
		case 1036:r+="&#1040;";break;
		case 1038:r+="&#1069;";break;
		case 1039:r+="&#1075;&#1072;";break;
		case 1040:r+="&#1048;";break;
		case 1041:r+="&#1075;&#1048;";break;
		case 1042:r+="&#1048;";break;
		case 1043:r+="&#1075;&#1048;";break;
		case 1044:r+="&#1086;";break;
		case 1045:r+="&#1054;";break;
		case 1046:r+="&#1054;";break;
                case 1047:r+="&#1054;";break;
		case 1048:r+="&#1086;";break;
		case 1049:r+="&#1075;&#1086;";break;
		case 1050:r+="&#1054;";break;
		case 1051:r+="&#1075;&#1054;";break;
		case 1052:r+="&#1054;";break;
		case 1053:r+="&#1075;&#1054;";break;
		case 1054:r+="&#1054;";break;
		case 1055:r+="&#1075;&#1054;";break;
		case 1056:r+="&#1054;";break;
		case 1057:r+="&#1054;";break;
		case 1058:r+="&#1054;";break;
		case 1059:r+="&#1086;";break;
		case 1060:r+="&#1075;&#1086;";break;
		case 1061:r+="&#1054;";break;
		case 1062:r+="&#1075;&#1054;";break;
		case 1063:r+="&#1086;";break;
		case 1064:r+="&#1075;&#1086;";break;
		case 1065:r+="&#1086;";break;
		case 1066:r+="&#1075;&#1054;";break;

		case 1067:r+="&#1048;";break;
		case 1068:r+="&#1048;";break;
		case 1069:r+="&#1048;";break;
		case 1070:r+="&#1080;";break;
		case 1071:r+="&#1075;&#1080;";break;
		case 1072:r+="&#1048;";break;
		case 1073:r+="&#1075;&#1048;";break;
		case 1074:r+="&#1048;";break;
		case 1075:r+="&#1075;&#1048;";break;
		case 1076:r+="&#1048;";break;
		case 1077:r+="&#1075;&#1048;";break;

		case 1078:r+="&#1048;";break;
		case 1079:r+="&#1048;";break;
		case 1080:r+="&#1048;";break;
		case 1081:r+="&#1080;";break;
		case 1082:r+="&#1075;&#1080;";break;
		case 1083:r+="&#1048;";break;
		case 1084:r+="&#1075;&#1048;";break;
		case 1085:r+="&#1048;";break;
		case 1086:r+="&#1075;&#1048;";break;
		case 1087:r+="&#1048;";break;
		case 1088:r+="&#1075;&#1048;";break;

	        case 1089:r+="&#1054;";break;
	        case 1090:r+="&#1054;";break;
	        case 1091:r+="&#1080;";break;
	        case 1092:r+="&#1086;";break;
	        case 1093:r+="&#1075;&#1086;";break;
	        case 1094:r+="&#1054;";break;
	        case 1095:r+="&#1075;&#1054;";break;
	        case 1096:r+="&#1054;";break;
	        case 1097:r+="&#1075;&#1054;";break;
	        case 1098:r+="&#1080;";break;
	        case 1099:r+="&#1089;";break;
	        case 1101:r+="&#1048;";break;
	        case 1102:r+="&#1048;";break;
	        case 1105:r+="&#1048;";break;
	        case 1106:r+="&#1040;";break;
	        case 1107:r+="";break;
	        case 1108:r+="&#1048;";break;
	        case 1109:case 1110:r+="&#1048;";break;
	        case 1111:r+="&#1075;&#1048;";break;
	        case 1112:r+="&#1080;";break;
	        case 1113:r+="&#1075;&#1072;";break;
	        case 1114:r+="&#1075;&#1040;";break;
	        case 1115:r+="&#1075;&#1040;";break;
	        case 1116:r+="&#1040;";break;
	        case 1118:r+="&#1069;";break;
	        case 1119:r+="&#1040;";break;
	        case 1168:r+="&#1075;&#1101;";break;
	        case 1169:r+="&#1075;&#1048;";break;
		
		case 8211:r+='&#1040;';break;
		case 8212:r+='&#1040;';break;
		case 8216:r+='&#1075;&#1040;';break;
		case 8217:r+='&#1040;';break;
		case 8218:r+='';break;
		case 8220:r+='&#1075;&#1040;';break;
		case 8221:r+='&#1040;';break;
		case 8222:switch (s.charAt(t+1)){case "R":break;default:r+='&#1075;';}break;
		case 8224: case 1033: case 228: r+='&#1075;';switch (s.charAt(t+1)) {
		        	case "A":r+='&#1040;';t++;break;
				case "E":r+='&#1069;';t++;break;
				case "H":r+='&#1048;';t++;break;
				case "I":r+='&#1048;';t++;break;
				case "O":r+='&#1054;';t++;break;
				case "U":r+='&#1048;';t++;break;
				case "V":r+='&#1054;';t++;break;
			}
			break;
		case 8225:case 8230:switch (s.charAt(t+1)) {
		        	case "A":r+='&#1040;';t++;break;
				case "E":r+='&#1069;';t++;break;
				case "H":r+='&#1048;';t++;break;
				case "I":r+='&#1048;';t++;break;
				case "O":r+='&#1054;';t++;break;
				case "U":r+='&#1048;';t++;break;
				case "V":r+='&#1054;';t++;break;
			}
			break;
		case 8225:r+='';break;
		case 8226:r+='&#1075;&#1040;';break;
		case 8230:r+='';break;
		case 8240:r+='';break;
		case 8249:r+='&#1040;';break;
		case 8250:r+='&#1040;';break;
		case 8364:r+='&#1075;';break;

		case 8470:r+='&#1048;';break;
		//default: r+='+'+s.charCodeAt(t)+'+';document.write(r);
	}
  }
}
  //r+=" ( ";for (t=0;t<s.length;t++) r+=s.charCodeAt(t)+" ";r+=")";

  return r;
}


function diftongER(s,t,v,V){
 switch(s.charCodeAt(t+1)){
  case 73:return v+"&#1081;";
  case 85:return v+"&#1091;";
  case 105:return v+"&#1081;";
  case 117:return v+"&#1091;";
  case 1067:return V+"&#1081;";
  case 1068:return V+"&#1081;";
  case 1069:return V+"&#1081;";
  case 1070:return v+"&#1081;";
  case 1071:return "&#1075;"+v+"&#1081;";
  case 1072:return V+"&#1081;";
  case 1073:return "&#1075;"+V+"&#1081;";
  case 1075:return "&#1075;"+V+"&#1081;";
  case 1076:return V+"&#1081;";
  case 1077:return "&#1075;"+V+"&#1081;";
  case 1078:return V+"&#1091;";
  case 1079:return V+"&#1091;";
  case 1080:return v+"&#1091;";
  case 1081:return v+"&#1091;";
  case 1082:return "&#1075;"+v+"&#1091;";
  case 1083:return V+"&#1091;";
  case 1084:return "&#1075;"+V+"&#1091;";
  case 1085:return V+"&#1091;";
  case 1086:return "&#1075;"+V+"&#1091;";
  case 1087:return V+"&#1091;";
  case 1088:return "&#1075;"+v+"&#1091;";
  default: return "";
 }
}

function digraphER(s,t,v,V){
 if (s.length<t+1) return "";
 switch(s.charAt(t+1)){
  case "U":case "u":return "&#1091;";
  default: switch(s.charCodeAt(t+1)){
   case 1078:return "&#1059;";
   case 1079:return "&#1059;";
   case 1080:return "&#1059;";
   case 1081:return "&#1091;";
   case 1084:return "&#1075;&#1059;";
   case 1085:return "&#1059;";
   case 1086:return "&#1075;&#1059;";
   case 1087:return "&#1059;";
   case 1088:return "&#1075;&#1059;";
   default: return diftongER(s,t,v,V);
  }
 }
}

function translitER(s){
r='';
for (t=0;t<s.length;t++) {
 switch(s.charAt(t)) {
	case "A": case "a":d=diftongER(s,t,"&#1072;","&#1040;");if(d!="") {r+=d;t++;} else r+="&#1072;";break;
	case "B": case "b":r+="&#1073;";break;
	case "G": case "g":if (t){switch(s.charAt(t+1)) {case "G":case "g":case "K":case "k":case "X":case "x":case "J":case "j":r+="&#1085;";break; default: r+="&#1075;";}} else r+="&#1075;";break;
	case "D": case "d":r+="&#1076;";break;
	case "E": case "e":d=diftongER(s,t,"&#1101;","&#1069;");if(d!="") {r+=d;t++;} else r+="&#1101;";break;
	case "Z": case "z":r+="&#1076;&#1079;";break;
	case "H": case "h": d=diftongER(s,t,"&#1101;","&#1069;");if(d!="") {r+=d;t++;} else r+="&#1101;";break;
	case "Y": case "y":r+="&#1090;&#1093;";break;
	case "I": case "i":r+="&#1080;";break;
	case "K": case "k":r+="&#1082;";break;
	case "L": case "l":r+="&#1083;";break;
	case "M": case "m":r+="&#1084;";break;
	case "N": case "n":r+="&#1085;";break;
	case "J": case "j":r+="&#1082;&#1089;";break;
	case "O": case "o":d=digraphER(s,t,"&#1086;","&#1054;");if (d!="") {r+=d; t++;} else r+="&#1086;";break;
	case "P": case "p":r+="&#1087;";break;
	case "R": case "r":r+="&#1088;";break;
	case "S": case "s": case "w":r+="&#1089;";break;
	case "T": case "t":r+="&#1090;";break;
	case "U": case "u":switch(s.charCodeAt(t+1)){case 1071:r+="&#1075;&#1102;&#1081;";t++;break;default:r+="&#1102;";}break;
	case "F": case "f":r+="&#1092;";break;
	case "X": case "x":r+="&#1093;";break;
	case "C": case "c":r+="&#1087;&#1089;";break;
	case "V": case "v":r+="&#1086;";break;
	default: switch(s.charCodeAt(t)) {
		case 35:r+="&#1102;";break;
		case 38:r+="&#1072;";break;
		case 44:r+=" ";break;
		case 61:r+="&#1088;";break;
		case 64:r+="&#1070;";break;
		case 123:r+=" ";break;
		case 125:r+=" ";break;
		case 152:r+="&#1040;";break;
		case 161:r+="&#1075;&#1069;";break;
		case 162:r+="&#1069;";break;
		case 163:r+="&#1070;";break;
		case 164:r+="&#1101;";break;
		case 165:r+="&#1075;&#1069;";break;
		case 166:r+="&#1069;";break;
		case 167:r+="&#1075;&#1069;";break;
		case 169:r+="&#1075;&#1069;";break;
		case 170:r+="&#1069;";break;
		case 172:r+="&#1069;";break;
		case 174:r+="&#1069;";break;
		case 175:r+="&#1054;";break;
		case 176:r+="&#1069;";break;
		case 177:r+="&#1101;";break;
		case 181:r+="&#1069;";break;
		case 182:r+="&#1075;&#1069;";break;
		case 183:r+="&#1069;";break;
		case 186:r+="&#1101;";break;
		case 187:r+="&#1069;";break;
		case 191:r+="&#1069;";break;
		case 192:r+="&#1075;&#1054;";break;
		case 193:r+="&#1070;";break;
		case 194:r+="&#1075;&#1048;";break;
		case 195:r+="&#1054;";break;
		case 198:r+="&#1069;";break;
		case 200:r+="&#1102;";break;
		case 201:r+="";break;
		case 202:r+="&#1070;";break;
		case 203:r+="&#1070;";break;
		case 204:r+="&#1070;";break;
		case 205:r+="&#1075;&#1102;";break;
		case 206:r+="&#1070;";break;
		case 207:r+="&#1075;&#1070;";break;
		case 209:r+="&#1075;";break;
		case 210:r+="&#1054;";break;
		case 211:r+="&#1075;&#1070;";break;
		case 212:r+="&#1070;";break;
		case 213:r+="&#1075;&#1054;";break;
		case 216:r+="&#1069;";break;
		case 217:r+="&#1086;";break;
		case 218:r+="&#1054;";break;
		case 219:r+="&#1080;";break;
		case 223:r+="&#1075;&#1069;";break;
		case 227:r+="&#1040;";break;
		//case 228: see next
		case 229:r+="&#1040;";break;
		case 230:r+="&#1069;";break;
		case 231:r+="&#1040;";break;
		case 232:r+="&#1075;&#1072;";break;
		case 233:r+="&#1072;";break;
		case 234:r+="&#1040;";break;
		case 235:r+="&#1075;&#1040;";break;
		case 236:r+="&#1075;&#1040;";break;
		case 237:r+="&#1040;";break;
		case 238:r+="&#1040;";break;
		case 239:r+="&#1075;&#1040;";break;
		case 241:r+="&#1040;";break;
		case 243:r+="&#1040;";break;
		case 244:r+="&#1072;";break;
		case 245:r+="&#1040;";break;
		case 246:r+="&#1075;&#1072;";break;
		case 247:r+="&#1075;&#1054;";break;
		case 248:r+="&#1075;&#1069;";break;
		case 249:r+="&#1040;";break;
		case 250:r+="&#1075;&#1040;";break;
		case 251:r+="&#1075;&#1040;";break;
		case 252:r+="&#1040;";break;
		case 255:r+="&#1075;&#1054;";break;
		case 1025:r+="&#1069;";break;
		case 1028:r+="&#1075;&#1040;";break;
		case 1029:case 1030:r+="&#1075;&#1101;";break;
		case 1031:r+="&#1069;";break;
		case 1032:r+="&#1070;";break;
		//case 1033: see next
		case 1034:r+="&#1040;";break;
		case 1035:r+="&#1072;";break;
		case 1036:r+="&#1040;";break;
		case 1038:r+="&#1069;";break;
		case 1039:r+="&#1075;&#1072;";break;
		case 1040:r+="&#1069;";break;
		case 1041:r+="&#1075;&#1069;";break;
		case 1042:r+="&#1069;";break;
		case 1043:r+="&#1075;&#1069;";break;
		case 1044:r+="&#1086;";break;
		case 1045:r+="&#1054;";break;
		case 1046:r+="&#1054;";break;
		case 1047:r+="&#1054;";break;
		case 1048:r+="&#1086;";break;
		case 1049:r+="&#1075;&#1086;";break;
		case 1050:r+="&#1054;";break;
		case 1051:r+="&#1075;&#1054;";break;
		case 1052:r+="&#1054;";break;
		case 1053:r+="&#1075;&#1054;";break;
		case 1054:r+="&#1054;";break;
		case 1055:r+="&#1075;&#1054;";break;
		case 1056:r+="&#1054;";break;
		case 1057:r+="&#1054;";break;
		case 1058:r+="&#1054;";break;
		case 1059:r+="&#1086;";break;
		case 1060:r+="&#1075;&#1086;";break;
		case 1061:r+="&#1054;";break;
		case 1062:r+="&#1075;&#1054;";break;
		case 1063:r+="&#1086;";break;
		case 1064:r+="&#1075;&#1086;";break;
		case 1065:r+="&#1086;";break;
		case 1066:r+="&#1075;&#1054;";break;

		case 1067:r+="&#1048;";break;
		case 1068:r+="&#1048;";break;
		case 1069:r+="&#1048;";break;
		case 1070:r+="&#1080;";break;
		case 1071:r+="&#1075;&#1080;";break;
		case 1072:r+="&#1048;";break;
		case 1073:r+="&#1075;&#1048;";break;
		case 1074:r+="&#1048;";break;
		case 1075:r+="&#1075;&#1048;";break;
		case 1076:r+="&#1048;";break;
		case 1077:r+="&#1075;&#1048;";break;

		case 1078:r+="&#1070;";break;
		case 1079:r+="&#1070;";break;
		case 1080:r+="&#1070;";break;
		case 1081:r+="&#1102;";break;
		case 1082:r+="&#1075;&#1102;";break;
		case 1083:r+="&#1070;";break;
		case 1084:r+="&#1075;&#1070;";break;
		case 1085:r+="&#1070;";break;
		case 1086:r+="&#1075;&#1070;";break;
		case 1087:r+="&#1070;";break;
		case 1088:r+="&#1075;&#1070;";break;

	        case 1089:r+="&#1054;";break;
	        case 1090:r+="&#1054;";break;
	        case 1091:r+="&#1080;";break;
	        case 1092:r+="&#1086;";break;
	        case 1093:r+="&#1075;&#1086;";break;
	        case 1094:r+="&#1054;";break;
	        case 1095:r+="&#1075;&#1054;";break;
	        case 1096:r+="&#1054;";break;
	        case 1097:r+="&#1075;&#1054;";break;
	        case 1098:r+="&#1101;";break;
	        case 1099:r+="&#1089;";break;
	        case 1101:r+="&#1048;";break;
	        case 1102:r+="&#1048;";break;
	        case 1105:r+="&#1069;";break;
	        case 1106:r+="&#1040;";break;
	        case 1107:r+="";break;
	        case 1108:r+="&#1069;";break;
	        case 1109:case 1110:r+="&#1069;";break;
	        case 1111:r+="&#1075;&#1069;";break;
	        case 1112:r+="&#1101;";break;
	        case 1113:r+="&#1075;&#1072;";break;
	        case 1114:r+="&#1075;&#1040;";break;
	        case 1115:r+="&#1075;&#1040;";break;
	        case 1116:r+="&#1040;";break;
	        case 1118:r+="&#1069;";break;
	        case 1119:r+="&#1040;";break;
	        case 1168:r+="&#1075;&#1101;";break;
	        case 1169:r+="&#1075;&#1069;";break;
		
		case 8211:r+='&#1040;';break;
		case 8212:r+='&#1040;';break;
		case 8216:r+='&#1075;&#1040;';break;
		case 8217:r+='&#1040;';break;
		case 8218:r+='';break;
		case 8220:r+='&#1075;&#1040;';break;
		case 8221:r+='&#1040;';break;
		case 8222:switch (s.charAt(t+1)){case "R":break;default:r+='&#1075;';}break;
		case 8224:case 1033:case 228:r+='&#1075;';switch (s.charAt(t+1)) {
		        	case "A":r+='&#1040;';t++;break;
				case "E":r+='&#1069;';t++;break;
				case "H":r+='&#1069;';t++;break;
				case "I":r+='&#1048;';t++;break;
				case "O":r+='&#1054;';t++;break;
				case "U":r+='&#1070;';t++;break;
				case "V":r+='&#1054;';t++;break;
			}
			break;
		case 8225:case 8230:switch (s.charAt(t+1)) {
		        	case "A":r+='&#1040;';t++;break;
				case "E":r+='&#1069;';t++;break;
				case "H":r+='&#1069;';t++;break;
				case "I":r+='&#1048;';t++;break;
				case "O":r+='&#1054;';t++;break;
				case "U":r+='&#1070;';t++;break;
				case "V":r+='&#1054;';t++;break;
			}
			break;
		case 8225:r+='';break;
		case 8226:r+='&#1075;&#1040;';break;
		case 8230:r+='';break;
		case 8240:r+='';break;
		case 8249:r+='&#1040;';break;
		case 8250:r+='&#1040;';break;
		case 8364:r+='&#1075;';break;

		case 8470:r+='&#1048;';break;
//		default: r+='+'+s.charCodeAt(t)+'+';document.write(r);
	}
  }
}
  //r+=" ( ";for (t=0;t<s.length;t++) r+=s.charCodeAt(t)+" ";r+=")";

  return r;
}


function getCookie(Name) {
 var search = Name + "=";
 if (document.cookie.length > 0) {
  offset = document.cookie.indexOf(search);
  if (offset != -1) {
   offset += search.length;
   end = document.cookie.indexOf(";", offset);
   if (end == -1) end = document.cookie.length;
   return unescape(document.cookie.substring(offset, end));
  }
 }
}

function translit(s){
 if (getCookie("Underliner_Transcription")=="ER") return translitER(s); else if (getCookie("Underliner_Transcription")=="no") return ""; else return translitYR(s);
}


function add_titles(s){
  c='<a target="_blank" href="help.htm';
  s=s.replace(/#Aesch"/g,c+'#Aesch " title=" (525-456 .  ..)">Aesch.</a>');
  s=s.replace(/#Aeschin"/g,c+'#Aeschin" title=" (389-314 .  ..)">Aeschin.</a>');
  s=s.replace(/#Anacr"/g,c+'#Anacr" title=" (559-478 .  ..)">Anacr.</a>');
  s=s.replace(/#Anth"/g,c+'#Anth" title="  -      ">Anth.</a>');
  s=s.replace(/#Arph"/g,c+'#Arph" title=" (444-380 .  ..)">Arph.</a>');
  s=s.replace(/#Arst"/g,c+'#Arst" title=" (384-322 .  ..)">Arst.</a>');
  s=s.replace(/#Babr"/g,c+'#Babr" title=" (I-II . ..)">Babr.</a>');
  s=s.replace(/#Batr"/g,c+'#Batr" title=""   " ().  . (. X .  ..)">Batr.</a>');
  s=s.replace(/#Dem"/g,c+'#Dem" title=" (381-322 .  ..)">Dem.</a>');
  s=s.replace(/#Diod"/g,c+'#Diod" title="  (I .  ..)">Diod.</a>');
  s=s.replace(/#DiodL"/g,c+'#DiodL" title="  (I-II . ..)">Diod. L.</a>');
  s=s.replace(/#Epicur"/g,c+'#Epicur" title=" (IV .  ..)">Epicur.</a>');
  s=s.replace(/#Eur"/g,c+'#Eur" title=" (480-405 .  ..)">Eur.</a>');
  s=s.replace(/#HH"/g,c+'#HH" title="  (X-IX .  ..)">HH</a>');
  s=s.replace(/#Her"/g,c+'#Her" title=" (484-424 .  ..)">Her.</a>');
  s=s.replace(/#Hes"/g,c+'#Hes" title=" (IX .  ..)">Hes.</a>');
  s=s.replace(/#Hom"/g,c+'#Hom" title=" (X-IX .  ..)">Hom.</a>');
  s=s.replace(/#Isocr"/g,c+'#Isocr" title=" (436-338 .  ..)">Isocr.</a>');
  s=s.replace(/#Isae"/g,c+'#Isae" title=" (1- . IV .  ..)">Isae.</a>');
  s=s.replace(/#Luc"/g,c+'#Luc" title=" (1- . II . ..)">Luc.</a>');
  s=s.replace(/#Lys"/g,c+'#Lys" title=" (445-378 .  ..)">Lys.</a>');
  s=s.replace(/#Men"/g,c+'#Men" title=" (342-291 .  ..)">Men.</a>');
  s=s.replace(/#NT"/g,c+'#NT" title="Novum Testamentum (  I-II . ..)">NT</a>');
  s=s.replace(/#Pind"/g,c+'#Pind" title=" (522-442 .  ..)">Pind.</a>');
  s=s.replace(/#Plat"/g,c+'#Plat" title=" (427-347 .  ..)">Plat.</a>');
  s=s.replace(/#Plut"/g,c+'#Plut" title=" (45-120 .)">Plut.</a>');
  s=s.replace(/#Polyb"/g,c+'#Polyb" title=" (204-122 .  ..)">Polyb.</a>');
  s=s.replace(/#Sappho"/g,c+'#Sappho" title=" (VII-VI .  ..)">Sappho.</a>');
  s=s.replace(/#Sext"/g,c+'#Sext" title="Sextus Empiricus (  III . ..)">Sext.</a>');
  s=s.replace(/#Soph"/g,c+'#Soph" title=" (496-406 .  ..)">Soph.</a>');
  s=s.replace(/#Theocr"/g,c+'#Theocr" title=" (310-245 .  ..)">Theocr.</a>');
  s=s.replace(/#Thuc"/g,c+'#Thuc" title=" (460-400 .  ..)">Thuc.</a>');
  s=s.replace(/#Trag"/g,c+'#Trag" title=" , , ">Trag.</a>');
  s=s.replace(/#Xen"/g,c+'#Xen" title=" (444-354 .  ..)">Xen.</a>');

  s=s.replace(/#1"/g,c+'#1" title="1-  ()"><font color=green>1.</font></a>');
  s=s.replace(/#2"/g,c+'#2" title="2-  ()"><font color=green>2.</font></a>');
  s=s.replace(/#3"/g,c+'#3" title="3-  ()"><font color=green>3.</font></a>');
  s=s.replace(/#aor"/g,c+'#aor" title="aorist ()"><font color=green>aor.</font></a>');
  s=s.replace(/#aor1"/g,c+'#aor1" title="aorist 1 ( )"><font color=green>aor. 1</font></a>');
  s=s.replace(/#aor2"/g,c+'#aor2" title="aorist 2 ( )"><font color=green>aor. 2</font></a>');
  s=s.replace(/#adj"/g,c+'#adj" title="adjectivum ( )"><font color=green>adj.</font></a>');
  s=s.replace(/#conj"/g,c+'#conj" title="conjuctio ()"><font color=green>conj.</font></a>');
  s=s.replace(/#demin"/g,c+'#demin" title="deminutivum (    )"><font color=green>demin.</font></a>');
  s=s.replace(/#fut"/g,c+'#fut" title="futurum ( )"><font color=green>fut.</font></a>');
  s=s.replace(/#gen"/g,c+'#gen" title="genetivus ( )"><font color=green>gen.</font></a>');
  s=s.replace(/#impf"/g,c+'#impf" title="imperfectum ( )"><font color=green>impf.</font></a>');
  s=s.replace(/#inf"/g,c+'#inf" title="infinitivus ()"><font color=green>inf.</font></a>');
  s=s.replace(/#med"/g,c+'#med" title="medium ( )"><font color=green>med.</font></a>');
  s=s.replace(/#part"/g,c+'#part" title="participium ()"><font color=green>part.</font></a>');
  s=s.replace(/#pass"/g,c+'#pass" title="passivum ( )"><font color=green>pass.</font></a>');
  s=s.replace(/#pf"/g,c+'#pf" title="perfectum ()"><font color=green>pf.</font></a>');
  s=s.replace(/#pl"/g,c+'#pl" title="pluralis ( )"><font color=green>pl.</font></a>');
  s=s.replace(/#praes"/g,c+'#praes" title="praesens ( )"><font color=green>praes.</font></a>');
  s=s.replace(/#sing"/g,c+'#sing" title="singularis ( )"><font color=green>sing.</font></a>');
  s=s.replace(/#voc"/g,c+'#voc" title="vocativus ( )"><font color=green>voc.</font></a>');

  s=s.replace(/#"/g,c+'#" title=",  "><font color=green>.</font></a>');
  s=s.replace(/#"/g,c+'#" title=" "><font color=green>.</font></a>');
  s=s.replace(/#"/g,c+'#" title="  "><font color=green>.</font></a>');
  s=s.replace(/#"/g,c+'#" title=" "><font color=green>.</font></a>');
  s=s.replace(/#"/g,c+'#" title=" "><font color=green>.</font></a>');
  s=s.replace(/#"/g,c+'#" title=",  "><font color=green>.</font></a>');

  s=s.replace(/#"/g,c+'#" title=",     "><font color=green>.</font></a>');
  s=s.replace(/#"/g,c+'#" title=""><font color=green>.</font></a>');
  s=s.replace(/#"/g,c+'#" title=" "><font color=green>.</font></a>');

  s=s.replace(/#"/g,c+'#" title=""><font color=green>.</font></a>');
  s=s.replace(/#"/g,c+'#" title=" "><font color=green>.</font></a>');
  s=s.replace(/#"/g,c+'#" title="- "><font color=green>.</font></a>');

  s=s.replace(/#etc"/g,c+'#etc" title="et cetera (  )"><font color=green>etc.</font></a>');
  s=s.replace(/#ap"/g,c+'#ap" title="apud -  ( ,   )"><font color=green>ap.</font></a>');
  s=s.replace(/#sc"/g,c+'#sc" title="scilicet ()"><font color=green>sc.</font></a>');
  s=s.replace(/#vl"/g,c+'#vl" title="varia lectio ()"><font color=green>vl.</font></a>');
  s=s.replace(/#"/g,c+'#" title=" "><font color=green> .</font></a>');
  s=s.replace(/#"/g,c+'#" title=" "><font color=green> .</font></a>');
  s=s.replace(/#."/g,c+'#." title=" .."><font color=green>. .</font></a>');
  s=s.replace(/#"/g,c+'#" title=" .."><font color=green> .</font></a>');
  s=s.replace(/#incrasi"/g,c+'#incrasi" title="  ( )"><font color=green>in crasi</font></a>');
  s=s.replace(/#"/g,c+'#" title=" "><font color=green> .</font></a>');
  s=s.replace(/#adj.verb"/g,c+'#adj.verb" title="adjectivum verbale ( )"><font color=green>adj. verb.</font></a>');
  s=s.replace(/#"/g,c+'#" title=""><font color=green>.</font></a>');
  s=s.replace(/#"/g,c+'#" title=" "><font color=green>.</font></a>');
  s=s.replace(/#"/g,c+'#" title=" "><font color=green>.</font></a>');
  s=s.replace(/#"/g,c+'#" title=""><font color=green>.</font></a>');
  s=s.replace(/#.."/g,c+'#.." title="-"><font color=green>.-.</font></a>');
  s=s.replace(/#"/g,c+'#" title=""><font color=green>.</font></a>');
  s=s.replace(/#"/g,c+'#" title=" "><font color=green>..</font></a>');

  s=s.replace(/#compar"/g,c+'#compar" title="comparativus ( )"><font color=green>compar.</font></a>');
  s=s.replace(/#"/g,c+'#" title=" "><font color=green>.</font></a>');
  s=s.replace(/#superl"/g,c+'#superl" title="superlativus (  )"><font color=green>superl.</font></a>');
  s=s.replace(/#"/g,c+'#" title="-"><font color=green>-.</font></a>');
  s=s.replace(/#"/g,c+'#" title="-"><font color=green>-.</font></a>');
  s=s.replace(/#"/g,c+'#" title="-"><font color=green>-.</font></a>');
  s=s.replace(/#"/g,c+'#" title="-"><font color=green>-.</font></a>');
  s=s.replace(/#"/g,c+'#" title="-"><font color=green>-.</font></a>');
  s=s.replace(/#"/g,c+'#" title="-"><font color=green>-.</font></a>');
  s=s.replace(/#"/g,c+'#" title="-"><font color=green>-.</font></a>');
  s=s.replace(/#adv"/g,c+'#adv" title="adverbium ()"><font color=green>adv.</font></a>');
  s=s.replace(/#"/g,c+'#" title=" "><font color=green>. .</font></a>');
  s=s.replace(/#inelisione"/g,c+'#inelisione" title="in elisione ( )"><font color=green>in elisione</font></a>');
  s=s.replace(/#"/g,c+'#" title=""><font color=green>.</font></a>');
  s=s.replace(/#"/g,c+'#" title=" "><font color=green> .</font></a>');
  s=s.replace(/#"/g,c+'#" title="  "><font color=green>.</font></a>');
  s=s.replace(/#m"/g,c+'#m" title="masculinum ( )"><font color=green>m</font></a>');
  s=s.replace(/#"/g,c+'#" title="  "><font color=green> . </font></a>');
  s=s.replace(/#"/g,c+'#" title=""><font color=green>.</font></a>');
  s=s.replace(/#imper"/g,c+'#imper" title="imparativus ( )"><font color=green>imper.</font></a>');
  s=s.replace(/#"/g,c+'#" title=""><font color=green>.</font></a>');
  s=s.replace(/#"/g,c+'#" title=""><font color=green>.</font></a>');

  s=s.replace(/#I"/g,'<font color=red><b>I</b></font>');
  s=s.replace(/#II"/g,'<font color=red><b>II</b></font>');
  s=s.replace(/#III"/g,'<font color=red><b>III</b></font>');
  s=s.replace(/#IV"/g,'<font color=red><b>IV</b></font>');
  s=s.replace(/#V"/g,'<font color=red><b>V</b></font>');
  s=s.replace(/#VI"/g,'<font color=red><b>VI</b></font>');

  return s;
}

var UniFont='GrkU';

function isFullUnicode() {
 var testString = "%u1f77%u1f76%u1f34";
 var testSize = '72px';
 var h = document.getElementsByTagName("body")[0];
 var s = document.createElement("span");
 var res=0;
 s.style.fontSize = testSize;
 s.innerHTML = unescape(testString);
 s.style.fontFamily = 'Arial';
 h.appendChild(s);
 if (s.offsetWidth>45 && s.offsetWidth<51) res=1;
 //document.write('width='+s.offsetWidth+' height='+s.offsetHeight+' res='+res+'<br>');
 h.removeChild(s);
 return res;
};


function Uni(s){
r='';
var service=false;
for (t=0;t<s.length;t++) {
 if (service) {
	r+=s.charAt(t);
	if (s.charAt(t)==">") service=false;
 } else
 switch(s.charAt(t)) {
        case "<": service=true; r+="<"; break;
	case "A": r+="%u0391";break;
	case "B": r+="%u0392";break;
	case "G": r+="%u0393";break;  
	case "D": r+="%u0394";break;
	case "E": r+="%u0395";break;
	case "Z": r+="%u0396";break;
	case "H": r+="%u0397";break;
	case "Y": r+="%u0398";break; 
	case "I": r+="%u0399";break;
	case "K": r+="%u039a";break;
	case "L": r+="%u039b";break;
	case "M": r+="%u039c";break;
	case "N": r+="%u039d";break;
	case "J": r+="%u039e";break; 
	case "O": r+="%u039f";break;
	case "P": r+="%u03a0";break;
	case "R": r+="%u03a1";break;
	case "S": r+="%u03a3";break;
	case "T": r+="%u03a4";break;
	case "U": r+="%u03a5";break;
	case "F": r+="%u03a6";break;
	case "X": r+="%u03a7";break;
	case "C": r+="%u03a8";break;
	case "V": r+="%u03a9";break;

	case "a": r+="%u03b1";break;
	case "b": r+="%u03b2";break;
	case "g": r+="%u03b3";break;
	case "d": r+="%u03b4";break;
	case "e": r+="%u03b5";break;
	case "z": r+="%u03b6";break;
	case "h": r+="%u03b7";break;
	case "y": r+="%u03b8";break;
	case "i": r+="%u03b9";break;
	case "k": r+="%u03ba";break;
	case "l": r+="%u03bb";break;
	case "m": r+="%u03bc";break;
	case "n": r+="%u03bd";break;
	case "j": r+="%u03be";break;
	case "o": r+="%u03bf";break;
	case "p": r+="%u03c0";break;
	case "r": r+="%u03c1";break;
	case "s": r+="%u03c3";break;
	case "t": r+="%u03c4";break;
	case "u": r+="%u03c5";break;
	case "f": r+="%u03c6";break;
	case "x": r+="%u03c7";break;
	case "c": r+="%u03c8";break;
	case "v": r+="%u03c9";break;
	case "w": r+="%u03c2";break;
	case "[": r+="[";break;
	case "]": r+="]";break;
	case "-": r+="-";break;

	case " ": r+=" ";break;

	default: switch(s.charCodeAt(t)) {
		case 35: r+="%u03cb";break;
		case 38: r+="%u1fb3";break;
		case 44: r+=",";break;
		case 46: r+=".";break;
		case 58: r+="%u0387";break;
		case 59: r+="%u037e";break;
		case 61: r+="%u03c1";break;
		case 64: r+="%u03b0";break;
		case 152: r+="%u1fb7";break;
		case 164: r+="%u1f10";break; //r+="%u03b5";
		case 166: r+="%u1f14";break; //r+="%u03ad";
		case 167: r+="%u03ad";break;
		case 169: r+="%u03b5";break;
		case 174: r+="%u03ae";break;
		case 176: r+="%u1fc6";break; //r+="%u03b7";
		case 177: r+="%u1f20";break;
		case 181: r+="%u1f22";break;
		case 182: r+="%u1f23";break;
		case 183: r+="%u1f26";break;
		case 187: r+="%u1fc7";break; //r+="%u03b7%u0323"
		case 1025: r+="%u03b5";break; 
		case 1026: r+="%u0301";break; 
		case 1027: r+="%u0300";break; 
		case 1028: r+="%u03b1%u0323";break; 
		case 1029: r+="%u03b7%u0323";break; 
		case 1030: r+="%u1f21";break; 
		case 1031: r+="%u1f74";break; 
		case 1032: r+="%u03cb";break; 
		case 1033: break; 
		case 1034: r+="%u1f70";break; 
		case 1035: r+="%u1f00";break; 
		case 1036: r+="%u1fb6";break; 
		case 1038: r+="%u1f73";break;
		case 1039: r+="%u03b1";break;
		case 1040: r+="%u03b7%u0323";break;
		case 1041: r+="%u03b7%u0323";break;
		case 1042: r+="%u03b7%u0323";break;
		case 1043: r+="%u03b7%u0323";break;
		case 1044: r+="%u03c9%u0323";break;
		case 1045: r+="%u03ce";break;
		case 1046: r+="%u1f7c";break;
		case 1047: r+="%u1ff6";break;
		case 1048: r+="%u1f60";break;
		case 1049: r+="%u1f61";break;
		case 1050: r+="%u1f64";break;
		case 1051: r+="%u1f65";break;
		case 1052: r+="%u1f62";break;
		case 1053: r+="%u1f63";break;
		case 1054: r+="%u1f66";break;
		case 1055: r+="%u1f67";break;
		case 1056: r+="%u03ce%u0323";break;
		case 1057: r+="%u03c9%u0323";break;
		case 1058: r+="%u03c9%u0323";break;
		case 1059: r+="%u03c9%u0323";break;
		case 1060: r+="%u03c9%u0323";break;
		case 1061: r+="%u03ce%u0323";break;
		case 1062: r+="%u03ce%u0323";break;
		case 1063: r+="%u03c9%u0323";break;
		case 1064: r+="%u03c9%u0323";break;
		case 1065: r+="%u03c9%u0323";break;
		case 1066: r+="%u03c9%u0323";break;
		case 1067: r+="%u1f77";break;
		case 1068: r+="%u1f76";break; //r+="%u03b9";
		case 1069: r+="%u1fd6";break; 
		case 1070: r+="%u1f30";break; 
		case 1071: r+="%u1f31";break; 
		case 1072: r+="%u1f34";break; //r+="%u03af";
		case 1073: r+="%u1f35";break; 
		case 1074: r+="%u1f32";break; 
		case 1075: r+="%u1f33";break; 
		case 1076: r+="%u1f36";break; 
		case 1077: r+="%u1f37";break; 
		case 1078: r+="%u1f7b";break; 
		case 1079: r+="%u1f7a";break; //r+="%u03c5";
		case 1080: r+="%u1fe6";break; //r+="%u0169";
		case 1081: r+="%u1f50";break;
		case 1082: r+="%u1f51";break;
		case 1083: r+="%u1f54";break;
		case 1084: r+="%u1f55";break;
		case 1085: r+="%u1f52";break;
		case 1086: r+="%u1f53";break;
		case 1087: r+="%u1f56";break; //r+="%u0169";
		case 1088: r+="%u1f57";break; //r+="%u0169";
		case 1089: r+="%u03cc";break; //!
		case 1090: r+="%u1f78";break;
		case 1091: r+="%u03ca";break;
		case 1092: r+="%u1f40";break;
		case 1093: r+="%u1f41";break;
		case 1094: r+="%u1f44";break;
		case 1095: r+="%u1f45";break;
		case 1096: r+="%u1f42";break;
		case 1097: r+="%u1f43";break;
		case 1098: r+="%u03b7%u0323";break;
		case 1099: r+="%u03c2";break;
		case 1100: break;
		case 1101: r+="%u0390";break;
		case 1102: r+="%u03ca";break;
		case 1105: r+="%u03b7";break;
		case 1106: r+="%u03ac";break;
		case 1107: r+="%u2019";break;
		case 1108: r+="%u03b7%u0323";break;
		case 1109: r+="%u03ae%u0323";break;
		case 1110: r+="%u1f24";break;
		case 1111: r+="%u03ae%u0323";break;
		case 1112: r+="%u03b7%u0323";break;
		case 1113: r+="%u03b1%u0323";break;
		case 1114: r+="%u03ac%u0323";break;
		case 1115: r+="%u03b1%u0323";break;
		case 1116: r+="%u03b1%u0323";break;
		case 1118: r+="%u1f72";break; //r+="%u03b5";
		case 1119: r+="%u03b1%u0323";break;
		case 1168: r+="%u1f11";break; //r+="%u03b5";
		case 1169: r+="%u03ae";break;
		case 8209: r+="-";break;
		case 8211: r+="%u03ac%u0323";break;
		case 8212: r+="%u03b1%u0323";break;
		case 8216: r+="%u03ac";break;
		case 8217: r+="%u03b1";break;
		case 8218: break;
		case 8220: r+="%u1f03";break;
		case 8221: r+="%u1f06";break;
		case 8222: r+="%u201b";break;
		case 8224: r+="%u201b";break;
		case 8225: r+="%u2019";break;
		case 8226: r+="%u03b1";break;
		case 8230: r+="%u2019";break;
		case 8240: r+="%u2019";break;
		case 8242: break;
		case 8243: break;
		case 8249: r+="%u03ac";break;
		case 8250: r+="%u03ac%u0323";break;
		case 8364: r+="%u201b";break;
		case 8470: r+="%u03ae%u0323";break;
		case 8482: r+="%u03b1%u0323";break;
		case 8486: r+="%u03a9";break;
	}
 }
}
 return unescape(r);	
}   


function cite2Uni(s){
 var o=s;
 while(1){
  var k=o.search('<cite>');
  if (k<0) break;
  var i1=o.substr(0,k);
  o=o.substr(k+6,s.length);
  k=o.search('</cite>');
  var i2=o.substr(0,k);
  i2=Uni(unescape(i2));
  o=o.substr(k+7,s.length);
  o=i1+'<Cite>'+i2+'</Cite>'+o;
 }
 o=o.replace(/<cite>/g,'<cite><font face=&#92&#39GrkV&#92&#39>');
 o=o.replace(/<\/cite>/g,'</font></cite>');
 return o;
}


if (isFullUnicode()==0) UniFont='GrkU';

R=""+location;
if (R.indexOf("%25")>=0) {
 R=decodeURIComponent(R);
}
b=R.indexOf("#");R=R.substr(b+1,R.length);R=unescape(R);
UniEncoding=getCookie("Greek_Encoding");
if (UniEncoding=="UUNICODE") UniEncoding="UNICODE";
if (UniEncoding!="UNICODE" && UniEncoding!="GrkV"){
 var d = new Detector();
 if (d.detect('GrkV')==false){
  UniEncoding='UNICODE'; //no GrkV.ttf and no user settings - use UNICODE
 }
}

S="<center><h2>  </h2></center>";
for(i=0;i<a.length;i+=3){
m=a[i+2].split("~");
if(b==-1 || a[i]==R){
 S+="<br><sup title='"+translit(a[i])+"'>";
 if (UniEncoding=="UNICODE") {
  S+="<font face='"+UniFont+"'>"+Uni(a[i])+"</font>";
 } else S+=a[i];
 S+="</sup><br><br>";
 if (a[i+1]!="") {
        S+="<dir><table border=1><tr><td><table border=0><tr><th>";
	S+="<b> :</b></th></tr><tr><td><dir><br>";
	if (UniEncoding=="UNICODE") S+=cite2Uni(add_titles(a[i+1]))+"</dir>";
	 else 
	S+=add_titles(a[i+1])+"</dir>";
	S+="</td></tr></table></td></tr></table></dir><br><br>";
 }
 for (T=0;T<m.length;T+=4){
  S+="<a href='../"+m[T+1]+".htm#"+escape(m[T])+"' target='_blank' title='"+translit(m[T])+"'><dfn>";
  if (UniEncoding=="UNICODE") {
   S+="<font face='"+UniFont+"'>"+Uni(m[T])+"</font>";
  } else S+=m[T];
  S+="</dfn></a> ("+m[T+2]+")";
  z=m[T+3].split("_");
  for (k=0;k<z.length;k+=2){
   if (k>0) S+=",";
   S+=" "+z[k]+" <small>("+z[k+1]+")</small>";
  }
  S+="<br>";
 }
 S+="<hr>"}
 if(!(i&31)){g=100*i/a.length;status=g-g%1+"%";}
}
status="";
S+="<P ALIGN='RIGHT'><a href='g_simph.html' target=_blank>  </a><br><a href='../../index.htm' target=_blank> </a><br><a href='http://www.bible.in.ua'>www.bible.in.ua</a></P>";
document.write(S);