var Detector = function() {
    var baseFonts = ['monospace', 'sans-serif', 'serif'];
    var testString = "mmmmmmmmmmlli";
    var testSize = '72px';
    var h = document.getElementsByTagName("body")[0];
    var s = document.createElement("span");
    s.style.fontSize = testSize;
    s.innerHTML = testString;
    var defaultWidth = {};
    var defaultHeight = {};
    for (var index in baseFonts) {
        s.style.fontFamily = baseFonts[index];
        h.appendChild(s);
        defaultWidth[baseFonts[index]] = s.offsetWidth; //width for the default font
        defaultHeight[baseFonts[index]] = s.offsetHeight; //height for the defualt font
        h.removeChild(s);
    }
    function detect(font) {
        var detected = false;
        for (var index in baseFonts) {
            s.style.fontFamily = font + ',' + baseFonts[index]; // name of the font along with the base font for fallback.
            h.appendChild(s);
            var matched = (s.offsetWidth != defaultWidth[baseFonts[index]] || s.offsetHeight != defaultHeight[baseFonts[index]]);
            h.removeChild(s);
            detected = detected || matched;
        }
        return detected;
    }
    this.detect = detect;
};

function diftongYRa(s,t,v,V){
 switch(s.charCodeAt(t+1)){
  case 73:return "&#1101;";  //
  case 85:return v+"&#1091;"; //+
  case 105:return "&#1101;";  //
  case 117:return v+"&#1091;";
  case 1067:return "&#1069;"; //
  case 1068:return "&#1069;";
  case 1069:return "&#1069;";
  case 1070:return "&#1101;";
  case 1071:return "&#1075;"+"&#1101;";
  case 1072:return "&#1069;";
  case 1073:return "&#1075;&#1069;";
  case 1074:return "&#1069;";
  case 1075:return "&#1075;&#1069;";
  case 1076:return "&#1069;";
  case 1077:return "&#1075;&#1069;";
  case 1078:return V+"&#1091;";
  case 1079:return V+"&#1091;";
  case 1080:return V+"&#1091;";
  case 1081:return v+"&#1091;";
  case 1082:return "&#1075;"+v+"&#1091;";
  case 1083:return V+"&#1091;";
  case 1084:return "&#1075;"+V+"&#1091;";
  case 1085:return V+"&#1091;";
  case 1086:return "&#1075;"+V+"&#1091;";
  case 1087:return V+"&#1091;";
  case 1088:return "&#1075;"+V+"&#1091;";
  default: return "";
 }
}

function diftongYRe(s,t,v,V){
 switch(s.charCodeAt(t+1)){
  case 73:return "&#1080;";  //
  case 85:return v+"&#1091;"; //+
  case 105:return "&#1080;";  //
  case 117:return v+"&#1091;";
  case 1067:return "&#1048;"; //
  case 1068:return "&#1048;";
  case 1069:return "&#1048;";
  case 1070:return "&#1080;";
  case 1071:return "&#1075;"+"&#1080;";
  case 1072:return "&#1048;";
  case 1073:return "&#1075;&#1048;";
  case 1074:return "&#1048;";
  case 1075:return "&#1075;&#1048;";
  case 1076:return "&#1048;";
  case 1077:return "&#1075;&#1048;";
  case 1078:return V+"&#1091;";
  case 1079:return V+"&#1091;";
  case 1080:return V+"&#1091;";
  case 1081:return v+"&#1091;";
  case 1082:return "&#1075;"+v+"&#1091;";
  case 1083:return V+"&#1091;";
  case 1084:return "&#1075;"+V+"&#1091;";
  case 1085:return V+"&#1091;";
  case 1086:return "&#1075;"+V+"&#1091;";
  case 1087:return V+"&#1091;";
  case 1088:return "&#1075;"+V+"&#1091;";
  default: return "";
 }
}

function diftongYRh(s,t,v,V){
 switch(s.charCodeAt(t+1)){
  case 85:return v+"&#1091;"; //+
  case 117:return v+"&#1091;";
  case 1078:return V+"&#1091;";
  case 1079:return V+"&#1091;";
  case 1080:return V+"&#1091;";
  case 1081:return v+"&#1091;";
  case 1082:return "&#1075;"+v+"&#1091;";
  case 1083:return V+"&#1091;";
  case 1084:return "&#1075;"+V+"&#1091;";
  case 1085:return V+"&#1091;";
  case 1086:return "&#1075;"+V+"&#1091;";
  case 1087:return V+"&#1091;";
  case 1088:return "&#1075;"+V+"&#1091;";
  default: return "";
 }
}

function diftongYRou(s,t,v,V){
 switch(s.charCodeAt(t+1)){
  case 73:return "&#1080;";  //
  case 105:return "&#1080;"; // 
  case 1067:return "&#1048;"; //
  case 1068:return "&#1048;";
  case 1069:return "&#1048;";
  case 1070:return "&#1080;";
  case 1071:return "&#1075;"+"&#1080;";
  case 1072:return "&#1048;";
  case 1073:return "&#1075;&#1048;";
  case 1074:return "&#1048;";
  case 1075:return "&#1075;&#1048;";
  case 1076:return "&#1048;";
  case 1077:return "&#1075;&#1048;";
  default: return "";
 }
}


function digraphYR(s,t,v,V){
 if (s.length<t+1) return "";
 switch(s.charAt(t+1)){
  case "u":case "U":return "&#1091;";
  default: switch(s.charCodeAt(t+1)){
   case 1078:return "&#1059;";
   case 1079:return "&#1059;";
   case 1080:return "&#1059;";
   case 1081:return "&#1091;";
   case 1082:return "&#1075;"+"&#1091;";
   case 1083:return "&#1059;";
   case 1084:return "&#1075;&#1059;";
   case 1085:return "&#1059;";
   case 1086:return "&#1075;&#1059;";
   case 1087:return "&#1059;";
   case 1088:return "&#1075;&#1059;";
   default: return diftongYRou(s,t,v,V);
  }
 }
}


function translitYR(s){
r='';
for (t=0;t<s.length;t++) {
 switch(s.charAt(t)) {
	case "A": case "a":d=diftongYRa(s,t,"&#1072;","&#1040;");if(d!="") {r+=d;t++;} else r+="&#1072;";break;
	case "B": case "b":r+="&#1074;";break;
	case "G": case "g":if (t){switch(s.charAt(t+1)) {case "G":case "g":case "K":case "k":case "X":case "x":case "J":case "j":r+="&#1085;";break; default: r+="&#1075;";}} else r+="&#1075;";break;
	case "D": case "d":r+="&#1076;";break;
	case "E": case "e":d=diftongYRe(s,t,"&#1101;","&#1069;");if(d!="") {r+=d;t++;} else r+="&#1101;";break;
	case "Z": case "z":r+="&#1076;&#1079;";break;
	case "H": case "h":d=diftongYRh(s,t,"&#1080;","&#1048;");if(d!="") {r+=d;t++;} else r+="&#1080;";break;
	case "Y": case "y":r+="&#1092;";break;
	case "I": case "i":r+="&#1080;";break;
	case "K": case "k":r+="&#1082;";break;
	case "L": case "l":r+="&#1083;";break;
	case "M": case "m":r+="&#1084;";break;
	case "N": case "n":r+="&#1085;";break;
	case "J": case "j":r+="&#1082;&#1089;";break;
	case "O": case "o":d=digraphYR(s,t,"&#1086;","&#1054;");if (d!="") {r+=d; t++;} else r+="&#1086;";break;
	case "P": case "p":r+="&#1087;";break;
	case "R": case "r":r+="&#1088;";break;
	case "S": case "s": case "w":r+="&#1089;";break;
	case "T": case "t":r+="&#1090;";break;
	case "U": case "u":d=diftongYRou(s,t,"&#1080;","&#1048;");if(d!=""){r+=d;t++;} else r+="&#1080;";break;
	case "F": case "f":r+="&#1092;";break;
	case "X": case "x":r+="&#1093;";break;
	case "C": case "c":r+="&#1087;&#1089;";break;
	case "V": case "v":r+="&#1086;";break;
	default: switch(s.charCodeAt(t)) {
		case 35:r+="&#1080;";break;
		case 38:r+="&#1072;";break;
		case 44:r+=" ";break;
		case 61:r+="&#1088;";break;
		case 64:r+="&#1048;";break;
		case 123:r+=" ";break;
		case 125:r+=" ";break;
		case 152:r+="&#1040;";break;
		case 161:r+="&#1075;&#1048;";break;
		case 162:r+="&#1069;";break;
		case 163:r+="&#1048;";break;
		case 164:r+="&#1101;";break;
		case 165:r+="&#1075;&#1048;";break;
		case 166:r+="&#1069;";break;
		case 167:r+="&#1075;&#1069;";break;
		case 169:r+="&#1075;&#1069;";break;
		case 170:r+="&#1048;";break;
		case 172:r+="&#1048;";break;
		case 174:r+="&#1048;";break;
		case 175:r+="&#1054;";break;
		case 176:r+="&#1048;";break;
		case 177:r+="&#1080;";break;
		case 181:r+="&#1048;";break;
		case 182:r+="&#1075;&#1048;";break;
		case 183:r+="&#1048;";break;
		case 186:r+="&#1080;";break;
		case 187:r+="&#1048;";break;
		case 191:r+="&#1048;";break;
		case 192:r+="&#1075;&#1054;";break;
		case 193:r+="&#1048;";break;
		case 194:r+="&#1075;&#1048;";break;
		case 195:r+="&#1054;";break;
		case 198:r+="&#1048;";break;
		case 200:r+="&#1080;";break;
		case 201:r+="";break;
		case 202:r+="&#1048;";break;
		case 203:r+="&#1048;";break;
		case 204:r+="&#1048;";break;
		case 205:r+="&#1075;&#1080;";break;
		case 206:r+="&#1048;";break;
		case 207:r+="&#1075;&#1048;";break;
		case 209:r+="&#1075;";break;
		case 210:r+="&#1054;";break;
		case 211:r+="&#1075;&#1048;";break;
		case 212:r+="&#1048;";break;
		case 213:r+="&#1075;&#1054;";break;
		case 216:r+="&#1048;";break;
		case 217:r+="&#1086;";break;
		case 218:r+="&#1054;";break;
		case 219:r+="&#1080;";break;
		case 223:r+="&#1075;&#1069;";break;
		case 227:r+="&#1040;";break;
		//case 228: see next
		case 229:r+="&#1040;";break;
		case 230:r+="&#1048;";break;
		case 231:r+="&#1040;";break;
		case 232:r+="&#1075;&#1072;";break;
		case 233:r+="&#1072;";break;
		case 234:r+="&#1040;";break;
		case 235:r+="&#1075;&#1040;";break;
		case 236:r+="&#1075;&#1040;";break;
		case 237:r+="&#1040;";break;
		case 238:r+="&#1040;";break;
		case 239:r+="&#1075;&#1040;";break;
		case 241:r+="&#1040;";break;
		case 243:r+="&#1040;";break;
		case 244:r+="&#1072;";break;
		case 245:r+="&#1040;";break;
		case 246:r+="&#1075;&#1072;";break;
		case 247:r+="&#1075;&#1054;";break;
		case 248:r+="&#1075;&#1048;";break;
		case 249:r+="&#1040;";break;
		case 250:r+="&#1075;&#1040;";break;
		case 251:r+="&#1075;&#1040;";break;
		case 252:r+="&#1040;";break;
		case 255:r+="&#1075;&#1054;";break;
		case 1025:r+="&#1069;";break;
		case 1028:r+="&#1075;&#1040;";break;
		case 1029:case 1030:r+="&#1075;&#1080;";break;
		case 1031:r+="&#1048;";break;
		case 1032:r+="&#1048;";break;
		//case 1032: see next
		case 1034:r+="&#1040;";break;
		case 1035:r+="&#1072;";break;
		case 1036:r+="&#1040;";break;
		case 1038:r+="&#1069;";break;
		case 1039:r+="&#1075;&#1072;";break;
		case 1040:r+="&#1048;";break;
		case 1041:r+="&#1075;&#1048;";break;
		case 1042:r+="&#1048;";break;
		case 1043:r+="&#1075;&#1048;";break;
		case 1044:r+="&#1086;";break;
		case 1045:r+="&#1054;";break;
		case 1046:r+="&#1054;";break;
                case 1047:r+="&#1054;";break;
		case 1048:r+="&#1086;";break;
		case 1049:r+="&#1075;&#1086;";break;
		case 1050:r+="&#1054;";break;
		case 1051:r+="&#1075;&#1054;";break;
		case 1052:r+="&#1054;";break;
		case 1053:r+="&#1075;&#1054;";break;
		case 1054:r+="&#1054;";break;
		case 1055:r+="&#1075;&#1054;";break;
		case 1056:r+="&#1054;";break;
		case 1057:r+="&#1054;";break;
		case 1058:r+="&#1054;";break;
		case 1059:r+="&#1086;";break;
		case 1060:r+="&#1075;&#1086;";break;
		case 1061:r+="&#1054;";break;
		case 1062:r+="&#1075;&#1054;";break;
		case 1063:r+="&#1086;";break;
		case 1064:r+="&#1075;&#1086;";break;
		case 1065:r+="&#1086;";break;
		case 1066:r+="&#1075;&#1054;";break;

		case 1067:r+="&#1048;";break;
		case 1068:r+="&#1048;";break;
		case 1069:r+="&#1048;";break;
		case 1070:r+="&#1080;";break;
		case 1071:r+="&#1075;&#1080;";break;
		case 1072:r+="&#1048;";break;
		case 1073:r+="&#1075;&#1048;";break;
		case 1074:r+="&#1048;";break;
		case 1075:r+="&#1075;&#1048;";break;
		case 1076:r+="&#1048;";break;
		case 1077:r+="&#1075;&#1048;";break;

		case 1078:r+="&#1048;";break;
		case 1079:r+="&#1048;";break;
		case 1080:r+="&#1048;";break;
		case 1081:r+="&#1080;";break;
		case 1082:r+="&#1075;&#1080;";break;
		case 1083:r+="&#1048;";break;
		case 1084:r+="&#1075;&#1048;";break;
		case 1085:r+="&#1048;";break;
		case 1086:r+="&#1075;&#1048;";break;
		case 1087:r+="&#1048;";break;
		case 1088:r+="&#1075;&#1048;";break;

	        case 1089:r+="&#1054;";break;
	        case 1090:r+="&#1054;";break;
	        case 1091:r+="&#1080;";break;
	        case 1092:r+="&#1086;";break;
	        case 1093:r+="&#1075;&#1086;";break;
	        case 1094:r+="&#1054;";break;
	        case 1095:r+="&#1075;&#1054;";break;
	        case 1096:r+="&#1054;";break;
	        case 1097:r+="&#1075;&#1054;";break;
	        case 1098:r+="&#1080;";break;
	        case 1099:r+="&#1089;";break;
	        case 1101:r+="&#1048;";break;
	        case 1102:r+="&#1048;";break;
	        case 1105:r+="&#1048;";break;
	        case 1106:r+="&#1040;";break;
	        case 1107:r+="";break;
	        case 1108:r+="&#1048;";break;
	        case 1109:case 1110:r+="&#1048;";break;
	        case 1111:r+="&#1075;&#1048;";break;
	        case 1112:r+="&#1080;";break;
	        case 1113:r+="&#1075;&#1072;";break;
	        case 1114:r+="&#1075;&#1040;";break;
	        case 1115:r+="&#1075;&#1040;";break;
	        case 1116:r+="&#1040;";break;
	        case 1118:r+="&#1069;";break;
	        case 1119:r+="&#1040;";break;
	        case 1168:r+="&#1075;&#1101;";break;
	        case 1169:r+="&#1075;&#1048;";break;
		
		case 8211:r+='&#1040;';break;
		case 8212:r+='&#1040;';break;
		case 8216:r+='&#1075;&#1040;';break;
		case 8217:r+='&#1040;';break;
		case 8218:r+='';break;
		case 8220:r+='&#1075;&#1040;';break;
		case 8221:r+='&#1040;';break;
		case 8222:switch (s.charAt(t+1)){case "R":break;default:r+='&#1075;';}break;
		case 8224: case 1033: case 228: r+='&#1075;';switch (s.charAt(t+1)) {
		        	case "A":r+='&#1040;';t++;break;
				case "E":r+='&#1069;';t++;break;
				case "H":r+='&#1048;';t++;break;
				case "I":r+='&#1048;';t++;break;
				case "O":r+='&#1054;';t++;break;
				case "U":r+='&#1048;';t++;break;
				case "V":r+='&#1054;';t++;break;
			}
			break;
		case 8225:case 8230:switch (s.charAt(t+1)) {
		        	case "A":r+='&#1040;';t++;break;
				case "E":r+='&#1069;';t++;break;
				case "H":r+='&#1048;';t++;break;
				case "I":r+='&#1048;';t++;break;
				case "O":r+='&#1054;';t++;break;
				case "U":r+='&#1048;';t++;break;
				case "V":r+='&#1054;';t++;break;
			}
			break;
		case 8225:r+='';break;
		case 8226:r+='&#1075;&#1040;';break;
		case 8230:r+='';break;
		case 8240:r+='';break;
		case 8249:r+='&#1040;';break;
		case 8250:r+='&#1040;';break;
		case 8364:r+='&#1075;';break;

		case 8470:r+='&#1048;';break;
		//default: r+='+'+s.charCodeAt(t)+'+';document.write(r);
	}
  }
}
  //r+=" ( ";for (t=0;t<s.length;t++) r+=s.charCodeAt(t)+" ";r+=")";

  return r;
}


function diftongER(s,t,v,V){
 switch(s.charCodeAt(t+1)){
  case 73:return v+"&#1081;";
  case 85:return v+"&#1091;";
  case 105:return v+"&#1081;";
  case 117:return v+"&#1091;";
  case 1067:return V+"&#1081;";
  case 1068:return V+"&#1081;";
  case 1069:return V+"&#1081;";
  case 1070:return v+"&#1081;";
  case 1071:return "&#1075;"+v+"&#1081;";
  case 1072:return V+"&#1081;";
  case 1073:return "&#1075;"+V+"&#1081;";
  case 1075:return "&#1075;"+V+"&#1081;";
  case 1076:return V+"&#1081;";
  case 1077:return "&#1075;"+V+"&#1081;";
  case 1078:return V+"&#1091;";
  case 1079:return V+"&#1091;";
  case 1080:return v+"&#1091;";
  case 1081:return v+"&#1091;";
  case 1082:return "&#1075;"+v+"&#1091;";
  case 1083:return V+"&#1091;";
  case 1084:return "&#1075;"+V+"&#1091;";
  case 1085:return V+"&#1091;";
  case 1086:return "&#1075;"+V+"&#1091;";
  case 1087:return V+"&#1091;";
  case 1088:return "&#1075;"+v+"&#1091;";
  default: return "";
 }
}

function digraphER(s,t,v,V){
 if (s.length<t+1) return "";
 switch(s.charAt(t+1)){
  case "U":case "u":return "&#1091;";
  default: switch(s.charCodeAt(t+1)){
   case 1078:return "&#1059;";
   case 1079:return "&#1059;";
   case 1080:return "&#1059;";
   case 1081:return "&#1091;";
   case 1084:return "&#1075;&#1059;";
   case 1085:return "&#1059;";
   case 1086:return "&#1075;&#1059;";
   case 1087:return "&#1059;";
   case 1088:return "&#1075;&#1059;";
   default: return diftongER(s,t,v,V);
  }
 }
}

function translitER(s){
r='';
for (t=0;t<s.length;t++) {
 switch(s.charAt(t)) {
	case "A": case "a":d=diftongER(s,t,"&#1072;","&#1040;");if(d!="") {r+=d;t++;} else r+="&#1072;";break;
	case "B": case "b":r+="&#1073;";break;
	case "G": case "g":if (t){switch(s.charAt(t+1)) {case "G":case "g":case "K":case "k":case "X":case "x":case "J":case "j":r+="&#1085;";break; default: r+="&#1075;";}} else r+="&#1075;";break;
	case "D": case "d":r+="&#1076;";break;
	case "E": case "e":d=diftongER(s,t,"&#1101;","&#1069;");if(d!="") {r+=d;t++;} else r+="&#1101;";break;
	case "Z": case "z":r+="&#1076;&#1079;";break;
	case "H": case "h": d=diftongER(s,t,"&#1101;","&#1069;");if(d!="") {r+=d;t++;} else r+="&#1101;";break;
	case "Y": case "y":r+="&#1090;&#1093;";break;
	case "I": case "i":r+="&#1080;";break;
	case "K": case "k":r+="&#1082;";break;
	case "L": case "l":r+="&#1083;";break;
	case "M": case "m":r+="&#1084;";break;
	case "N": case "n":r+="&#1085;";break;
	case "J": case "j":r+="&#1082;&#1089;";break;
	case "O": case "o":d=digraphER(s,t,"&#1086;","&#1054;");if (d!="") {r+=d; t++;} else r+="&#1086;";break;
	case "P": case "p":r+="&#1087;";break;
	case "R": case "r":r+="&#1088;";break;
	case "S": case "s": case "w":r+="&#1089;";break;
	case "T": case "t":r+="&#1090;";break;
	case "U": case "u":switch(s.charCodeAt(t+1)){case 1071:r+="&#1075;&#1102;&#1081;";t++;break;default:r+="&#1102;";}break;
	case "F": case "f":r+="&#1092;";break;
	case "X": case "x":r+="&#1093;";break;
	case "C": case "c":r+="&#1087;&#1089;";break;
	case "V": case "v":r+="&#1086;";break;
	default: switch(s.charCodeAt(t)) {
		case 35:r+="&#1102;";break;
		case 38:r+="&#1072;";break;
		case 44:r+=" ";break;
		case 61:r+="&#1088;";break;
		case 64:r+="&#1070;";break;
		case 123:r+=" ";break;
		case 125:r+=" ";break;
		case 152:r+="&#1040;";break;
		case 161:r+="&#1075;&#1069;";break;
		case 162:r+="&#1069;";break;
		case 163:r+="&#1070;";break;
		case 164:r+="&#1101;";break;
		case 165:r+="&#1075;&#1069;";break;
		case 166:r+="&#1069;";break;
		case 167:r+="&#1075;&#1069;";break;
		case 169:r+="&#1075;&#1069;";break;
		case 170:r+="&#1069;";break;
		case 172:r+="&#1069;";break;
		case 174:r+="&#1069;";break;
		case 175:r+="&#1054;";break;
		case 176:r+="&#1069;";break;
		case 177:r+="&#1101;";break;
		case 181:r+="&#1069;";break;
		case 182:r+="&#1075;&#1069;";break;
		case 183:r+="&#1069;";break;
		case 186:r+="&#1101;";break;
		case 187:r+="&#1069;";break;
		case 191:r+="&#1069;";break;
		case 192:r+="&#1075;&#1054;";break;
		case 193:r+="&#1070;";break;
		case 194:r+="&#1075;&#1048;";break;
		case 195:r+="&#1054;";break;
		case 198:r+="&#1069;";break;
		case 200:r+="&#1102;";break;
		case 201:r+="";break;
		case 202:r+="&#1070;";break;
		case 203:r+="&#1070;";break;
		case 204:r+="&#1070;";break;
		case 205:r+="&#1075;&#1102;";break;
		case 206:r+="&#1070;";break;
		case 207:r+="&#1075;&#1070;";break;
		case 209:r+="&#1075;";break;
		case 210:r+="&#1054;";break;
		case 211:r+="&#1075;&#1070;";break;
		case 212:r+="&#1070;";break;
		case 213:r+="&#1075;&#1054;";break;
		case 216:r+="&#1069;";break;
		case 217:r+="&#1086;";break;
		case 218:r+="&#1054;";break;
		case 219:r+="&#1080;";break;
		case 223:r+="&#1075;&#1069;";break;
		case 227:r+="&#1040;";break;
		//case 228: see next
		case 229:r+="&#1040;";break;
		case 230:r+="&#1069;";break;
		case 231:r+="&#1040;";break;
		case 232:r+="&#1075;&#1072;";break;
		case 233:r+="&#1072;";break;
		case 234:r+="&#1040;";break;
		case 235:r+="&#1075;&#1040;";break;
		case 236:r+="&#1075;&#1040;";break;
		case 237:r+="&#1040;";break;
		case 238:r+="&#1040;";break;
		case 239:r+="&#1075;&#1040;";break;
		case 241:r+="&#1040;";break;
		case 243:r+="&#1040;";break;
		case 244:r+="&#1072;";break;
		case 245:r+="&#1040;";break;
		case 246:r+="&#1075;&#1072;";break;
		case 247:r+="&#1075;&#1054;";break;
		case 248:r+="&#1075;&#1069;";break;
		case 249:r+="&#1040;";break;
		case 250:r+="&#1075;&#1040;";break;
		case 251:r+="&#1075;&#1040;";break;
		case 252:r+="&#1040;";break;
		case 255:r+="&#1075;&#1054;";break;
		case 1025:r+="&#1069;";break;
		case 1028:r+="&#1075;&#1040;";break;
		case 1029:case 1030:r+="&#1075;&#1101;";break;
		case 1031:r+="&#1069;";break;
		case 1032:r+="&#1070;";break;
		//case 1033: see next
		case 1034:r+="&#1040;";break;
		case 1035:r+="&#1072;";break;
		case 1036:r+="&#1040;";break;
		case 1038:r+="&#1069;";break;
		case 1039:r+="&#1075;&#1072;";break;
		case 1040:r+="&#1069;";break;
		case 1041:r+="&#1075;&#1069;";break;
		case 1042:r+="&#1069;";break;
		case 1043:r+="&#1075;&#1069;";break;
		case 1044:r+="&#1086;";break;
		case 1045:r+="&#1054;";break;
		case 1046:r+="&#1054;";break;
		case 1047:r+="&#1054;";break;
		case 1048:r+="&#1086;";break;
		case 1049:r+="&#1075;&#1086;";break;
		case 1050:r+="&#1054;";break;
		case 1051:r+="&#1075;&#1054;";break;
		case 1052:r+="&#1054;";break;
		case 1053:r+="&#1075;&#1054;";break;
		case 1054:r+="&#1054;";break;
		case 1055:r+="&#1075;&#1054;";break;
		case 1056:r+="&#1054;";break;
		case 1057:r+="&#1054;";break;
		case 1058:r+="&#1054;";break;
		case 1059:r+="&#1086;";break;
		case 1060:r+="&#1075;&#1086;";break;
		case 1061:r+="&#1054;";break;
		case 1062:r+="&#1075;&#1054;";break;
		case 1063:r+="&#1086;";break;
		case 1064:r+="&#1075;&#1086;";break;
		case 1065:r+="&#1086;";break;
		case 1066:r+="&#1075;&#1054;";break;

		case 1067:r+="&#1048;";break;
		case 1068:r+="&#1048;";break;
		case 1069:r+="&#1048;";break;
		case 1070:r+="&#1080;";break;
		case 1071:r+="&#1075;&#1080;";break;
		case 1072:r+="&#1048;";break;
		case 1073:r+="&#1075;&#1048;";break;
		case 1074:r+="&#1048;";break;
		case 1075:r+="&#1075;&#1048;";break;
		case 1076:r+="&#1048;";break;
		case 1077:r+="&#1075;&#1048;";break;

		case 1078:r+="&#1070;";break;
		case 1079:r+="&#1070;";break;
		case 1080:r+="&#1070;";break;
		case 1081:r+="&#1102;";break;
		case 1082:r+="&#1075;&#1102;";break;
		case 1083:r+="&#1070;";break;
		case 1084:r+="&#1075;&#1070;";break;
		case 1085:r+="&#1070;";break;
		case 1086:r+="&#1075;&#1070;";break;
		case 1087:r+="&#1070;";break;
		case 1088:r+="&#1075;&#1070;";break;

	        case 1089:r+="&#1054;";break;
	        case 1090:r+="&#1054;";break;
	        case 1091:r+="&#1080;";break;
	        case 1092:r+="&#1086;";break;
	        case 1093:r+="&#1075;&#1086;";break;
	        case 1094:r+="&#1054;";break;
	        case 1095:r+="&#1075;&#1054;";break;
	        case 1096:r+="&#1054;";break;
	        case 1097:r+="&#1075;&#1054;";break;
	        case 1098:r+="&#1101;";break;
	        case 1099:r+="&#1089;";break;
	        case 1101:r+="&#1048;";break;
	        case 1102:r+="&#1048;";break;
	        case 1105:r+="&#1069;";break;
	        case 1106:r+="&#1040;";break;
	        case 1107:r+="";break;
	        case 1108:r+="&#1069;";break;
	        case 1109:case 1110:r+="&#1069;";break;
	        case 1111:r+="&#1075;&#1069;";break;
	        case 1112:r+="&#1101;";break;
	        case 1113:r+="&#1075;&#1072;";break;
	        case 1114:r+="&#1075;&#1040;";break;
	        case 1115:r+="&#1075;&#1040;";break;
	        case 1116:r+="&#1040;";break;
	        case 1118:r+="&#1069;";break;
	        case 1119:r+="&#1040;";break;
	        case 1168:r+="&#1075;&#1101;";break;
	        case 1169:r+="&#1075;&#1069;";break;
		
		case 8211:r+='&#1040;';break;
		case 8212:r+='&#1040;';break;
		case 8216:r+='&#1075;&#1040;';break;
		case 8217:r+='&#1040;';break;
		case 8218:r+='';break;
		case 8220:r+='&#1075;&#1040;';break;
		case 8221:r+='&#1040;';break;
		case 8222:switch (s.charAt(t+1)){case "R":break;default:r+='&#1075;';}break;
		case 8224:case 1033:case 228:r+='&#1075;';switch (s.charAt(t+1)) {
		        	case "A":r+='&#1040;';t++;break;
				case "E":r+='&#1069;';t++;break;
				case "H":r+='&#1069;';t++;break;
				case "I":r+='&#1048;';t++;break;
				case "O":r+='&#1054;';t++;break;
				case "U":r+='&#1070;';t++;break;
				case "V":r+='&#1054;';t++;break;
			}
			break;
		case 8225:case 8230:switch (s.charAt(t+1)) {
		        	case "A":r+='&#1040;';t++;break;
				case "E":r+='&#1069;';t++;break;
				case "H":r+='&#1069;';t++;break;
				case "I":r+='&#1048;';t++;break;
				case "O":r+='&#1054;';t++;break;
				case "U":r+='&#1070;';t++;break;
				case "V":r+='&#1054;';t++;break;
			}
			break;
		case 8225:r+='';break;
		case 8226:r+='&#1075;&#1040;';break;
		case 8230:r+='';break;
		case 8240:r+='';break;
		case 8249:r+='&#1040;';break;
		case 8250:r+='&#1040;';break;
		case 8364:r+='&#1075;';break;

		case 8470:r+='&#1048;';break;
		//default: r+='+'+s.charCodeAt(t)+'+';document.write(r);
	}
  }
}
  //r+=" ( ";for (t=0;t<s.length;t++) r+=s.charCodeAt(t)+" ";r+=")";

  return r;
}


function getCookie(Name) {
 var search = Name + "=";
 if (document.cookie.length > 0) {
  offset = document.cookie.indexOf(search);
  if (offset != -1) {
   offset += search.length;
   end = document.cookie.indexOf(";", offset);
   if (end == -1) end = document.cookie.length;
   return unescape(document.cookie.substring(offset, end));
  }
 }
}

function translit(s){
 if (getCookie("Underliner_Transcription")=="ER") return translitER(s); else if (getCookie("Underliner_Transcription")=="no") return ""; else return translitYR(s);
}


function rusword(s){
 re=/,/i;s=s.replace(re,"");
 re=/\./i;s=s.replace(re,"");
 re=/:/i;s=s.replace(re,"");
 re=/;/i;s=s.replace(re,"");
 re=/\?/i;s=s.replace(re,"");
 re=/<\[>/i;s=s.replace(re,"h\&#91;");
 re=/<\]>/i;s=s.replace(re,"h\&#93;");

 while (s.charAt(s.length-1)=="-") s=s.substr(0,s.length-1);
 while (s.charAt(0)=="-") s=s.substr(1,s.length);

 if (s.indexOf("<b>",0)<0) return s;
 re=/<b>/i;s=s.replace(re,"<u>");
 re=/<\/b>/i;s=s.replace(re,"</u>");
 return s;
}

var UniFont='GrkU';

function isFullUnicode() {
 var testString = "%u1f77%u1f76%u1f34";
 var testSize = '72px';
 var h = document.getElementsByTagName("body")[0];
 var s = document.createElement("span");
 var res=0;
 s.style.fontSize = testSize;
 s.innerHTML = unescape(testString);
 s.style.fontFamily = 'Arial';
 h.appendChild(s);
 if (s.offsetWidth>45 && s.offsetWidth<51) res=1;
 //document.write('width='+s.offsetWidth+' height='+s.offsetHeight+' res='+res+'<br>');
 h.removeChild(s);
 return res;
};

function Uni(s){
r='';
for (t=0;t<s.length;t++) {
 switch(s.charAt(t)) {
	case "A": r+="%u0391";break;
	case "B": r+="%u0392";break;
	case "G": r+="%u0393";break;  
	case "D": r+="%u0394";break;
	case "E": r+="%u0395";break;
	case "Z": r+="%u0396";break;
	case "H": r+="%u0397";break;
	case "Y": r+="%u0398";break; 
	case "I": r+="%u0399";break;
	case "K": r+="%u039a";break;
	case "L": r+="%u039b";break;
	case "M": r+="%u039c";break;
	case "N": r+="%u039d";break;
	case "J": r+="%u039e";break; 
	case "O": r+="%u039f";break;
	case "P": r+="%u03a0";break;
	case "R": r+="%u03a1";break;
	case "S": r+="%u03a3";break;
	case "T": r+="%u03a4";break;
	case "U": r+="%u03a5";break;
	case "F": r+="%u03a6";break;
	case "X": r+="%u03a7";break;
	case "C": r+="%u03a8";break;
	case "V": r+="%u03a9";break;

	case "a": r+="%u03b1";break;
	case "b": r+="%u03b2";break;
	case "g": r+="%u03b3";break;
	case "d": r+="%u03b4";break;
	case "e": r+="%u03b5";break;
	case "z": r+="%u03b6";break;
	case "h": r+="%u03b7";break;
	case "y": r+="%u03b8";break;
	case "i": r+="%u03b9";break;
	case "k": r+="%u03ba";break;
	case "l": r+="%u03bb";break;
	case "m": r+="%u03bc";break;
	case "n": r+="%u03bd";break;
	case "j": r+="%u03be";break;
	case "o": r+="%u03bf";break;
	case "p": r+="%u03c0";break;
	case "r": r+="%u03c1";break;
	case "s": r+="%u03c3";break;
	case "t": r+="%u03c4";break;
	case "u": r+="%u03c5";break;
	case "f": r+="%u03c6";break;
	case "x": r+="%u03c7";break;
	case "c": r+="%u03c8";break;
	case "v": r+="%u03c9";break;
	case "w": r+="%u03c2";break;
	case "[": r+="[";break;
	case "]": r+="]";break;
	case "-": r+="-";break;

	default: switch(s.charCodeAt(t)) {
		case 35: r+="%u03cb";break;
		case 38: r+="%u1fb3";break;
		case 44: r+=",";break;
		case 46: r+=".";break;
		case 58: r+="%u0387";break;
		case 59: r+="%u037e";break;
		case 61: r+="%u03c1";break;
		case 64: r+="%u03b0";break;
		case 152: r+="%u1fb7";break;
		case 164: r+="%u1f10";break; //r+="%u03b5";
		case 166: r+="%u1f14";break; //r+="%u03ad";
		case 167: r+="%u03ad";break;
		case 169: r+="%u03b5";break;
		case 174: r+="%u03ae";break;
		case 176: r+="%u1fc6";break; //r+="%u03b7";
		case 177: r+="%u1f20";break;
		case 181: r+="%u1f22";break;
		case 182: r+="%u1f23";break;
		case 183: r+="%u1f26";break;
		case 187: r+="%u1fc7";break; //r+="%u03b7%u0323"
		case 1025: r+="%u03b5";break; 
		case 1026: r+="%u0301";break; 
		case 1027: r+="%u0300";break; 
		case 1028: r+="%u03b1%u0323";break; 
		case 1029: r+="%u03b7%u0323";break; 
		case 1030: r+="%u1f21";break; 
		case 1031: r+="%u1f74";break; 
		case 1032: r+="%u03cb";break; 
		case 1033: break; 
		case 1034: r+="%u1f70";break; 
		case 1035: r+="%u1f00";break; 
		case 1036: r+="%u1fb6";break; 
		case 1038: r+="%u1f73";break;
		case 1039: r+="%u03b1";break;
		case 1040: r+="%u03b7%u0323";break;
		case 1041: r+="%u03b7%u0323";break;
		case 1042: r+="%u03b7%u0323";break;
		case 1043: r+="%u03b7%u0323";break;
		case 1044: r+="%u03c9%u0323";break;
		case 1045: r+="%u03ce";break;
		case 1046: r+="%u1f7c";break;
		case 1047: r+="%u1ff6";break;
		case 1048: r+="%u1f60";break;
		case 1049: r+="%u1f61";break;
		case 1050: r+="%u1f64";break;
		case 1051: r+="%u1f65";break;
		case 1052: r+="%u1f62";break;
		case 1053: r+="%u1f63";break;
		case 1054: r+="%u1f66";break;
		case 1055: r+="%u1f67";break;
		case 1056: r+="%u03ce%u0323";break;
		case 1057: r+="%u03c9%u0323";break;
		case 1058: r+="%u03c9%u0323";break;
		case 1059: r+="%u03c9%u0323";break;
		case 1060: r+="%u03c9%u0323";break;
		case 1061: r+="%u03ce%u0323";break;
		case 1062: r+="%u03ce%u0323";break;
		case 1063: r+="%u03c9%u0323";break;
		case 1064: r+="%u03c9%u0323";break;
		case 1065: r+="%u03c9%u0323";break;
		case 1066: r+="%u03c9%u0323";break;
		case 1067: r+="%u1f77";break;
		case 1068: r+="%u1f76";break; //r+="%u03b9";
		case 1069: r+="%u1fd6";break; 
		case 1070: r+="%u1f30";break; 
		case 1071: r+="%u1f31";break; 
		case 1072: r+="%u1f34";break; //r+="%u03af";
		case 1073: r+="%u1f35";break; 
		case 1074: r+="%u1f32";break; 
		case 1075: r+="%u1f33";break; 
		case 1076: r+="%u1f36";break; 
		case 1077: r+="%u1f37";break; 
		case 1078: r+="%u1f7b";break; 
		case 1079: r+="%u1f7a";break; //r+="%u03c5";
		case 1080: r+="%u1fe6";break; //r+="%u0169";
		case 1081: r+="%u1f50";break;
		case 1082: r+="%u1f51";break;
		case 1083: r+="%u1f54";break;
		case 1084: r+="%u1f55";break;
		case 1085: r+="%u1f52";break;
		case 1086: r+="%u1f53";break;
		case 1087: r+="%u1f56";break; //r+="%u0169";
		case 1088: r+="%u1f57";break; //r+="%u0169";
		case 1089: r+="%u03cc";break; //!
		case 1090: r+="%u1f78";break;
		case 1091: r+="%u03ca";break;
		case 1092: r+="%u1f40";break;
		case 1093: r+="%u1f41";break;
		case 1094: r+="%u1f44";break;
		case 1095: r+="%u1f45";break;
		case 1096: r+="%u1f42";break;
		case 1097: r+="%u1f43";break;
		case 1098: r+="%u03b7%u0323";break;
		case 1099: r+="%u03c2";break;
		case 1100: break;
		case 1101: r+="%u0390";break;
		case 1102: r+="%u03ca";break;
		case 1105: r+="%u03b7";break;
		case 1106: r+="%u03ac";break;
		case 1107: r+="%u2019";break;
		case 1108: r+="%u03b7%u0323";break;
		case 1109: r+="%u03ae%u0323";break;
		case 1110: r+="%u1f24";break;
		case 1111: r+="%u03ae%u0323";break;
		case 1112: r+="%u03b7%u0323";break;
		case 1113: r+="%u03b1%u0323";break;
		case 1114: r+="%u03ac%u0323";break;
		case 1115: r+="%u03b1%u0323";break;
		case 1116: r+="%u03b1%u0323";break;
		case 1118: r+="%u1f72";break; //r+="%u03b5";
		case 1119: r+="%u03b1%u0323";break;
		case 1168: r+="%u1f11";break; //r+="%u03b5";
		case 1169: r+="%u03ae";break;
		case 8209: r+="-";break;
		case 8211: r+="%u03ac%u0323";break;
		case 8212: r+="%u03b1%u0323";break;
		case 8216: r+="%u03ac";break;
		case 8217: r+="%u03b1";break;
		case 8218: break;
		case 8220: r+="%u1f03";break;
		case 8221: r+="%u1f06";break;
		case 8222: r+="%u201b";break;
		case 8224: r+="%u201b";break;
		case 8225: r+="%u2019";break;
		case 8226: r+="%u03b1";break;
		case 8230: r+="%u2019";break;
		case 8240: r+="%u2019";break;
		case 8242: break;
		case 8243: break;
		case 8249: r+="%u03ac";break;
		case 8250: r+="%u03ac%u0323";break;
		case 8364: r+="%u201b";break;
		case 8470: r+="%u03ae%u0323";break;
		case 8482: r+="%u03b1%u0323";break;
		case 8486: r+="%u03a9";break;
	}
 }
}
 return unescape(r);	
}   


function UUni(s){
r='';
for (t=0;t<s.length;t++) {
 switch(s.charAt(t)) {
	case "A":case "a": r+="%u0391";break;
	case "B":case "b": r+="%u0392";break;
	case "G":case "g": r+="%u0393";break;  
	case "D":case "d": r+="%u0394";break;
	case "E":case "e": r+="%u0395";break;
	case "Z":case "z": r+="%u0396";break;
	case "H":case "h": r+="%u0397";break;
	case "Y":case "y": r+="%u0398";break; 
	case "I":case "i": r+="%u0399";break;
	case "K":case "k": r+="%u039a";break;
	case "L":case "l": r+="%u039b";break;
	case "M":case "m": r+="%u039c";break;
	case "N":case "n": r+="%u039d";break;
	case "J":case "j": r+="%u039e";break; 
	case "O":case "o": r+="%u039f";break;
	case "P":case "p": r+="%u03a0";break;
	case "R":case "r": r+="%u03a1";break;
	case "S":case "s":case "w": r+="%u03a3";break;
	case "T":case "t": r+="%u03a4";break;
	case "U":case "u": r+="%u03a5";break;
	case "F":case "f": r+="%u03a6";break;
	case "X":case "x": r+="%u03a7";break;
	case "C":case "c": r+="%u03a8";break;
	case "V":case "v": r+="%u03a9";break;
	default: switch(s.charCodeAt(t)) {
		case 61: r+="%u03a1";break;
		case 1113:case 1115:case 1116:case 1119:case 8212:case 8217:case 8220:case 8221:case 8226:case 8482:case 1106:case 1114:case 8211:case 8216:case 8249:case 8250:case 38:case 152:case 1028:case 1034:case 1035:case 1036:case 1039: r+="%u0391";break;
		case 1118:case 1168:case 164:case 166:case 167:case 169:case 1025:case 1038: r+="%u0395";break;
		case 1045:case 1050:case 1051:case 1056:case 1061:case 1062:case 1044:case 1046:case 1047:case 1048:case 1049:case 1052:case 1053:case 1054:case 1055:case 1057:case 1058:case 1059:case 1060:case 1063:case 1064:case 1065:case 1066: r+="%u03a9";break;
		case 1101:case 1091:case 1102:case 1068:case 1069:case 1070:case 1071:case 1074:case 1075:case 1077:case 1067:case 1072:case 1076:case 1073: r+="%u0399";break; 
		case 1078:case 1083:case 1084:case 1079:case 1081:case 1082:case 1085:case 1086:case 35:case 64:case 1032:case 1080:case 1087:case 1088: r+="%u03a5";break;
		case 1090:case 1092:case 1093:case 1096:case 1097:case 1089:case 1094:case 1095: r+="%u039f";break;
		case 1109:case 1110:case 1111:case 1169:case 8470:case 1105:case 1098:case 1108:case 1112:case 174:case 176:case 177:case 181:case 182:case 183:case 187:case 1029:case 1030:case 1031:case 1040:case 1041:case 1042:case 1043: r+="%u0397";break;
		case 1099: r+="%u03a3";break;
		case 8486: r+="%u03a9";break;
	}
 }
}
 return unescape(r);	
}   

function hex(nnn){
 hexa=new Array('0','1','2','3','4','5','6','7','8','9','a','b','c','d','e','f');
 r='';
 r=hexa[nnn%16]+r;
 nnn=nnn>>4;
 r=hexa[nnn%16]+r;
 nnn=nnn>>4;
 r=hexa[nnn%16]+r;
 nnn=nnn>>4;
 r=hexa[nnn%16]+r;
 return r;
}

ne='';
nr='';

function getn(s){
 if(s=='51'){ne='Mt';nr='&#1052;&#1090;';}else
 if(s=='52'){ne='Mk';nr='&#1052;&#1082;';}else
 if(s=='53'){ne='Lk';nr='&#1051;&#1082;';}else
 if(s=='54'){ne='Jn';nr='&#1048;&#1085;';}else
 if(s=='55'){ne='Acts';nr='&#1044;&#1077;&#1103;&#1085;';}else
 if(s=='56'){ne='Jas';nr='&#1048;&#1072;&#1082;';}else
 if(s=='57'){ne='1Pet';nr='1&#1055;&#1077;&#1090;';}else
 if(s=='58'){ne='2Pet';nr='2&#1055;&#1077;&#1090;';}else
 if(s=='59'){ne='1Jn';nr='1&#1048;&#1085;';}else
 if(s=='60'){ne='2Jn';nr='2&#1048;&#1085;';}else
 if(s=='61'){ne='3Jn';nr='3&#1048;&#1085;';}else
 if(s=='62'){ne='Jude';nr='&#1048;&#1091;&#1076;';}else
 if(s=='63'){ne='Rom';nr='&#1056;&#1080;&#1084;';}else
 if(s=='64'){ne='1Cor';nr='1&#1050;&#1086;&#1088;';}else
 if(s=='65'){ne='2Cor';nr='2&#1050;&#1086;&#1088;';}else
 if(s=='66'){ne='Gal';nr='&#1043;&#1072;&#1083;';}else
 if(s=='67'){ne='Eph';nr='&#1045;&#1092;';}else
 if(s=='68'){ne='Phil';nr='&#1060;&#1083;&#1087;';}else
 if(s=='69'){ne='Col';nr='&#1050;&#1086;&#1083;';}else
 if(s=='70'){ne='1Thes';nr='1&#1060;&#1077;&#1089;';}else
 if(s=='71'){ne='2Thes';nr='2&#1060;&#1077;&#1089;';}else
 if(s=='72'){ne='1Tim';nr='1&#1058;&#1080;&#1084;';}else
 if(s=='73'){ne='2Tim';nr='2&#1058;&#1080;&#1084;';}else
 if(s=='74'){ne='Tit';nr='&#1058;&#1080;&#1090;';}else
 if(s=='75'){ne='Phlm';nr='&#1060;&#1083;&#1084;';}else
 if(s=='76'){ne='Heb';nr='&#1045;&#1074;&#1088;';}else
 if(s=='77'){ne='Rev';nr='&#1054;&#1090;&#1082;&#1088;';}else

 if(s=='1'){ne='Gen';nr='&#1041;&#1099;&#1090;';}else
 if(s=='2'){ne='Ex';nr='&#1048;&#1089;&#1093;';}else
 if(s=='3'){ne='Le';nr='&#1051;&#1077;&#1074;';}else
 if(s=='4'){ne='Nu';nr='&#1063;&#1080;&#1089;';}else
 if(s=='5'){ne='De';nr='&#1042;&#1090;&#1086;&#1088;';}else
 if(s=='8'){ne='Ru';nr='&#1056;&#1091;&#1092;&#1100;';}else

 if(s=='15'){ne='Ezr';nr='&#1045;&#1079;&#1076;';}else

 if(s=='18'){ne='Tov';nr='&#1058;&#1086;&#1074;';}else //
 if(s=='19'){ne='Judith';nr='&#1048;&#1091;&#1076;&#1080;&#1092;&#1100;';}else //
 if(s=='20'){ne='Es';nr='&#1045;&#1089;&#1092;';}else

 if(s=='24'){ne='Ec';nr='&#1045;&#1082;&#1082;&#1083;';}else
 if(s=='25'){ne='SS';nr='&#1055;&#1077;&#1089;&#1085;';}else

 if(s=='28'){ne='Isa';nr='&#1048;&#1089;';}else
 if(s=='30'){ne='Lam';nr='&#1055;&#1083;&#1072;&#1095;';}else
 if(s=='31'){ne='ep_Ieremiya';nr='&#1055;&#1086;&#1089;&#1083;.&#1048;&#1077;&#1088;';}else
 if(s=='32'){ne='Var';nr='&#1042;&#1072;&#1088;';}else

 if(s=='34'){ne='Da_F';nr='&#1044;&#1072;&#1085;(&#1060;)';}else
 if(s=='78'){ne='Da';nr='&#1044;&#1072;&#1085;';}else
 if(s=='35'){ne='Hos';nr='&#1054;&#1089;';}else
 if(s=='36'){ne='Joel';nr='&#1048;&#1086;&#1080;&#1083;';}else
 if(s=='37'){ne='Amos';nr='&#1040;&#1084;';}else
 if(s=='38'){ne='Obad';nr='&#1040;&#1074;&#1076;';}else
 if(s=='39'){ne='Jon';nr='&#1048;&#1086;&#1085;&#1072;';}else
 if(s=='40'){ne='Mic';nr='&#1052;&#1080;&#1093;';}else
 if(s=='41'){ne='Nah';nr='&#1053;&#1072;&#1091;&#1084;';}else
 if(s=='42'){ne='Hab';nr='&#1040;&#1074;&#1074;';}else
 if(s=='43'){ne='Zeph';nr='&#1057;&#1086;&#1092;';}else
 if(s=='44'){ne='Hag';nr='&#1040;&#1075;&#1075;';}else
 if(s=='45'){ne='Zech';nr='&#1047;&#1072;&#1093;';}else
 if(s=='46'){ne='Mal';nr='&#1052;&#1072;&#1083;';}else
 {ne='Unkn';nr='&#1053;&#1077;&#1080;&#1079;&#1074;';}
}

bb=new Array("","","","","","","","","","1","2","3","4","1","2","1","","2","","","","","","","","","","","","",""," ","","","","","","","","","","","","","","","","1","2","3","3",
"","","","","","","1","2","1","2","3","","","1","2","","","","","1","2","1","2","","","",""
);

function doTip(s,s2){
 sj="Tip('<iframe src=&#92&#39"+s+"&#92&#39 width=400 height=100></iframe>',ABOVE, true, TITLE, '  - "+s2+"')";
 sj=' onmouseover="'+sj+'" onmouseout="UnTip()"';
 return sj;
}


function doTip2(s,s2,n1){
 n=3+parseInt(n1);
 w='';
 if (n==1 || n==21) w='';
 sj="Tip('<iframe src=&#92&#39"+s+"&#92&#39 width=500 height=150></iframe>',ABOVE, true, TITLE, '  - "+s2+" (  "+n+" "+w+")')";
 sj=' onmouseover="'+sj+'" onmouseout="UnTip()"';
 return sj;
}


function remind(m) {
  element=document.getElementById(m);
  element.scrollIntoView(true);
}


function anotation2Uni(s,v){
 var o=s;
 while(1){
  var k=o.search('<sup>');
  if (k<0) break;
  var i1=o.substr(0,k);
  o=o.substr(k+5,1000);
  k=o.search('</sup>');
  var i2=o.substr(0,k);
  if (v==1) i2=Uni(unescape(i2));
   else i2=UUni(unescape(i2));
  o=o.substr(k+6,1000);
  o=i1+'<Sup>'+i2+'</Sup>'+o;
 }
 o=o.replace(/<sup>/g,'<sup><font face=&#92&#39'+UniFont+'&#92&#39>');
 o=o.replace(/<\/sup>/g,'</font></sub>');
 return o;
}

if (isFullUnicode()==0) UniFont='GrkU';

R=""+location;b=R.indexOf("#");R=R.substr(b+1,R.length);R=unescape(R);s="";
m=R.split(';');
R=m[0];
sbn=''+bn;
selected=false;
while (sbn.length<2) sbn='0'+sbn;
scn=''+cn;
while (scn.length<3) scn='0'+scn;
UniEncoding=getCookie("Greek_Encoding");
if (UniEncoding!="UNICODE" && UniEncoding!="UUNICODE" && UniEncoding!="GrkV") {
	var d = new Detector();
	if (d.detect('GrkV')==false) UniEncoding="UNICODE";
}

if (m[1]!='t') {
 document.write('<script type="text/javascript" src="../SUPP/tt.js"></script>');
 theight="height=80";
 tsmall="";
 tsmalle="";
} else {
 theight="height=50";
 tsmall="<small><small>";
 tsmalle="</small></small>";
}

prev=0;
for(i=0;i<a.length;i+=4){
 if (a[i]=="" && a[i+1]=="" && a[i+2]=="") {
  if (a[i+3].indexOf("<br>")==0 || a[i+3].indexOf("<br>")==1) { 
   if (!prev && i>12 && i<35) {
    //do <br> in terms of our format
    if (selected || m[1]!='t') 
    {
     document.write('<table '+theight+' border=0');
     if (selected && m[1]!='t') document.write(' bgcolor=#ffddff');
     document.write('><tr><td></td></tr><tr><td></td></tr></table>');
    } 
    prev=1;
   }
  } else { 
   if (!anot) {
    if (selected || m[1]!='t') {
     document.write('<table '+theight+' border=0 style="float: left;"');
     if (selected && m[1]!='t') document.write(' bgcolor=#ffddff');
     if (UniEncoding=="UNICODE") a[i+3]=anotation2Uni(a[i+3],1);
	else if (UniEncoding=="UUNICODE") a[i+3]=anotation2Uni(a[i+3],2);
     document.write('><tr><td>'+tsmall+a[i+3]+tsmalle+'</td></tr><tr><td></td></tr></table>');
    }
   } else {
    document.write(a[i+3]);
   }
   prev=0;
  }
 } else 
 if (a[i+3]=="") {
  prev=0;
  if (i<30) {
   if (m[1]!='t') document.write('<table '+theight+' border=0 style="float: left;" cellspacing=0 cellpadding=0><tr><td width=1>&nbsp;</td><td><nobr><sup><i>'+'<a href="../RSV/r.htm#'+sbn+';'+scn+'" target=_blank><font face="Arial" size=4 color=darkred>'+tsmall+unescape(a[i])+tsmalle+'</font></a></i></sup></nobr></td><td width=10>&nbsp;</td></tr></table>');
  } else {
   if (selected) {
     selected=false;
   }
   if (R==unescape(a[i])) {
     selected=true;
   }
   if (selected || m[1]!='t') {
    //document.write('<table '+theight+' border=0 style="float: left;" cellspacing=0 cellpadding=0');
    document.write('<table id="ver'+unescape(a[i])+'" '+theight+' border=0 style="float: left;" cellspacing=0 cellpadding=0');
    if (selected && m[1]!='t') document.write(' bgcolor=#ffccff');
    if (m[1]=='t') document.write('><tr><td width=1>&nbsp;</td><td><nobr><sup><i>'+'<a href="../RSV/r.htm#'+sbn+';'+scn+';'+unescape(a[i])+'" target=_blank><font face="Arial" size=4 color=darkred>'+tsmall+unescape(a[i])+tsmalle+'</font></a></i></sup></nobr></td><td width=10>&nbsp;</td></tr></table>');
     else document.write('><tr><td width=1>&nbsp;</td><td><nobr><sup><i>'+'<a href="../RSV/r.htm#'+sbn+';'+scn+';'+unescape(a[i])+'" target=_blank'+doTip("../RSV/'+sbn+'_'+scn+'.htm#"+unescape(a[i])+";t",bb[bn]+" "+cn+":"+unescape(a[i]))+' class="tip" style="border-bottom-color: #7f0000"><font face="Arial" size=4 color=darkred>'+tsmall+unescape(a[i])+tsmalle+'</font></a></i></sup></nobr></td><td width=10>&nbsp;</td></tr></table>');
   }
  }
 } else if (a[i+3]==" ") {
  prev=0;
  if (selected || m[1]!='t') {
   document.write('<table '+theight+' border=0 style="float: left;" cellspacing=0 cellpadding=0');
   if (selected && m[1]!='t') document.write(' bgcolor=#ffddff');
   document.write('><tr valign=bottom><td><nobr><sup>');
   if (UniEncoding=="UNICODE")
    document.write('<font face="'+UniFont+'" size=5><a href="../S/'+a[i+2]+'.htm#'+escape(unescape(a[i+1]))+'" target="_blank" title="'+translit(unescape(a[i+1]))+'">'+tsmall+Uni(unescape(a[i]))+tsmalle);
   else if (UniEncoding=="UUNICODE")
    document.write('<font face="'+UniFont+'" size=5><a href="../S/'+a[i+2]+'.htm#'+escape(unescape(a[i+1]))+'" target="_blank" title="'+translit(unescape(a[i+1]))+'">'+tsmall+UUni(unescape(a[i]))+tsmalle);
   else
    document.write('<font face="GrkV" size=5><a href="../S/'+a[i+2]+'.htm#'+escape(unescape(a[i+1]))+'" target="_blank" title="'+translit(unescape(a[i+1]))+'">'+tsmall+unescape(a[i])+tsmalle);
   document.write('</a></font></sup></nobr></td><td></td></tr><tr valign=top><td><font face="Arial" size=3>&nbsp;</font></td><td width=10></td></tr></table>');
  }
 } else {
  prev=0;
  if (selected || m[1]!='t') {
   document.write('<table '+theight+' border=0 style="float: left;" cellspacing=0 cellpadding=0');
   if (selected && m[1]!='t') document.write(' bgcolor=#ffddff');
   document.write('><tr valign=bottom><td><nobr><center><sup>');
   if (UniEncoding=="UNICODE") {
    document.write('<font face="'+UniFont+'" size=5><a href="../S/'+a[i+2]+'.htm#'+escape(unescape(a[i+1]))+'" target="_blank" title="'+translit(unescape(a[i+1]))+'">'+tsmall+Uni(unescape(a[i]))+tsmalle);
   } else if (UniEncoding=="UUNICODE") {
    document.write('<font face="'+UniFont+'" size=5><a href="../S/'+a[i+2]+'.htm#'+escape(unescape(a[i+1]))+'" target="_blank" title="'+translit(unescape(a[i+1]))+'">'+tsmall+UUni(unescape(a[i]))+tsmalle);
   } else {
    document.write('<font face="GrkV" size=5><a href="../S/'+a[i+2]+'.htm#'+escape(unescape(a[i+1]))+'" target="_blank" title="'+translit(unescape(a[i+1]))+'">'+tsmall+unescape(a[i])+tsmalle);
   }
   document.write('</a></font></sup></center></nobr></td><td></td></tr><tr valign=top><td><nobr><center><font face="Arial" size=3><a class=fancy href="../S/R/r.htm#'+escape(rusword(a[i+3]))+'" target="_blank">');
   if (rusword(a[i+3])==R) document.write('<b>'+tsmall+a[i+3]+tsmalle+'</b>'); else document.write(tsmall+a[i+3]+tsmalle);
   document.write('</a></font></center></nobr></td><td width=10></td></tr></table> ');
  }
 }
 if(!(i&31)) {g=100*i/a.length;window.status=g-g%1+"%";}
}

document.write('<font face="Arial">');

if (m[1]!='t') {
 document.write('<table '+theight+' border=0><tr><td></td></tr><tr><td></td></tr></table><table width=100% '+theight+' border=0 align=left><tr><td>');
 sout='';
 if (!anot) {
  for(i=0;i<cr.length;i++){
   m=cr[i].split(';');
   sout+='<font color=red>[<b>'+m[0]+'</b>]</font> ';
   for (i1=1;i1<m.length;i1++) {
    m1=m[i1].split(',');
    getn(m1[0]);
    if (bn>50 && m1[0]<51) ne='../OT/'+ne;
    if (bn<51 && m1[0]>50 && m1[0]<78) ne='../NT/'+ne;
    if (bn==78) ne='../OT/'+ne;
    if (m1[3]=='1') tm1='#000055'; else if (m1[3]=='2') tm1='#5500bb'; else if (m1[3]=='3') tm1='#aa00aa'; else tm1='#ff0000';
    //if (m1[0]==bn && m1[1]==cn) sout+='<nobr><a href="'+ne+m1[1]+'.htm#'+m1[2]+'" target=_blank><font color='+tm1+'>'+nr+' '+m1[1]+':'+m1[2]+'</font></a>;</nobr> ';
    if (m1[0]==bn && m1[1]==cn) sout+='<nobr><a href="'+ne+m1[1]+'.htm#'+m1[2]+'" target=_blank'+doTip2('../OT/'+ne+m1[1]+'.htm?1#'+m1[2]+';t',nr+' '+m1[1]+':'+m1[2],m1[3])+' class="tip" style="border-bottom-color: '+tm1+'"><font color='+tm1+'>'+nr+' '+m1[1]+':'+m1[2]+'</font></a>;</nobr> ';
     else sout+='<nobr><a href="'+ne+m1[1]+'.htm#'+m1[2]+'" target=_blank'+doTip2('../OT/'+ne+m1[1]+'.htm#'+m1[2]+';t',nr+' '+m1[1]+':'+m1[2],m1[3])+' class="tip" style="border-bottom-color: '+tm1+'"><font color='+tm1+'>'+nr+' '+m1[1]+':'+m1[2]+'</font></a>;</nobr> ';
   }
  }
 }
 if (sout!='') document.write('<br><hr><P ALIGN="JUSTIFY">'+sout+'</P>');

 document.write('<hr><table width=100% border=0><tr><td>');
 if (!anot) document.write('<a href="../RSV/r.htm#'+sbn+';'+scn+'" target=_blank title="&#1057;&#1080;&#1085;&#1086;&#1076;&#1072;&#1083;&#1100;&#1085;&#1099;&#1081; &#1087;&#1077;&#1088;&#1077;&#1074;&#1086;&#1076; &#1090;&#1077;&#1082;&#1089;&#1090;&#1072; &#1075;&#1083;&#1072;&#1074;&#1099;">&#1057;&#1080;&#1085;&#1086;&#1076;.&#1087;&#1077;&#1088;&#1077;&#1074;&#1086;&#1076; &#1075;&#1083;&#1072;&#1074;&#1099;</a>');
 if (!anot) document.write('<br><a href="../Lop/l.htm#'+sbn+';'+scn+'" target=_blank title="&#1050;&#1086;&#1084;&#1084;&#1077;&#1085;&#1090;&#1072;&#1088;&#1080;&#1080; &#1082; &#1090;&#1077;&#1082;&#1091;&#1097;&#1077;&#1081; &#1075;&#1083;&#1072;&#1074;&#1077; &#1080;&#1079; &#1090;&#1086;&#1083;&#1082;&#1086;&#1074;&#1086;&#1081; &#1041;&#1080;&#1073;&#1083;&#1080;&#1080; &#1040;.&#1055;.&#1051;&#1086;&#1087;&#1091;&#1093;&#1080;&#1085;&#1072;">&#1050;&#1086;&#1084;&#1084;&#1077;&#1085;&#1090;&#1072;&#1088;&#1080;&#1080; &#1082; &#1075;&#1083;&#1072;&#1074;&#1077;</a>');
 switch (bn) {
  case 73:case 74:break;
  default: document.write('<br><a href="../Lop/l.htm#'+sbn+';000" target=_blank title="&#1050;&#1086;&#1084;&#1084;&#1077;&#1085;&#1090;&#1072;&#1088;&#1080;&#1080; &#1082; &#1090;&#1077;&#1082;&#1091;&#1097;&#1077;&#1081; &#1082;&#1085;&#1080;&#1075;&#1077; &#1080;&#1079; &#1090;&#1086;&#1083;&#1082;&#1086;&#1074;&#1086;&#1081; &#1041;&#1080;&#1073;&#1083;&#1080;&#1080; &#1040;.&#1055;.&#1051;&#1086;&#1087;&#1091;&#1093;&#1080;&#1085;&#1072;">&#1050;&#1086;&#1084;&#1084;&#1077;&#1085;&#1090;&#1072;&#1088;&#1080;&#1080; &#1082; &#1082;&#1085;&#1080;&#1075;&#1077;</a>');break;
 }
 if (!anot && (variants!='' || parsing!='')) {
  document.write('</td><td><center>');
  if (variants!='') document.write('<a href="../S/V/'+variants+cn+'.htm" target=_blank title="&#1056;&#1072;&#1079;&#1085;&#1086;&#1095;&#1090;&#1077;&#1085;&#1080;&#1103; &#1074; &#1088;&#1091;&#1082;&#1086;&#1087;&#1080;&#1089;&#1103;&#1093;">&#1056;&#1072;&#1079;&#1085;&#1086;&#1095;&#1090;&#1077;&#1085;&#1080;&#1103; &#1074; &#1075;&#1083;&#1072;&#1074;&#1077;</a><br>');
  if (parsing!='') document.write('<a href="../S/P/'+parsing+'.htm" target=_blank title="&#1055;&#1077;&#1088;&#1077;&#1088;&#1072;&#1079;&#1073;&#1080;&#1074;&#1082;&#1072; &#1090;&#1077;&#1082;&#1089;&#1090;&#1072; &#1090;&#1077;&#1082;&#1091;&#1097;&#1077;&#1081; &#1075;&#1083;&#1072;&#1074;&#1099;">&#1055;&#1077;&#1088;&#1077;&#1088;&#1072;&#1079;&#1073;&#1080;&#1074;&#1082;&#1072; &#1090;&#1077;&#1082;&#1089;&#1090;&#1072;</a>');
  document.write('</center>');
 }
 document.write('</td><td><P ALIGN="RIGHT"><a href="../index.htm" target=_blank>&#1055;&#1086;&#1076;&#1089;&#1090;&#1088;&#1086;&#1095;&#1085;&#1099;&#1081; &#1087;&#1077;&#1088;&#1077;&#1074;&#1086;&#1076;</a><br><a href="http://www.bible.in.ua" target=_blank><small>www.bible.in.ua</small></a></P></td></tr></table>');

 document.write('</td></tr><tr><td></td></tr></table></font>');
 //document.write('<SCRIPT LANGUAGE="Javascript" SRC="http://www.bible.in.ua/d.php?show=0&page=underl&date=260207"></SCRIPT>');
 window.status="";

if (b>0) setTimeout(function(){element=document.getElementById("ver"+R);if (element) element.scrollIntoView(true);},100);
}
